#include <ctype.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>
#include <termios.h>
#include <syslog.h>
#include <string.h>
#include <netdb.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>

// 
#include "fprg.h"

/*
 * (c) 2002-2009 Dmitriy I.Cherkashin, www.ucrouter.ru
 * email: dch@ucrouter.ru , divch@users.sourceforge.net , dch@ucrouter.com 
 * phone: +8-909-936-8809; ICQ: 474-363-900; AIM:divchaim; YAHOO:divchyah
 */

// 
char	devnam[MAXPATHLEN] = "/dev/ttyS0";	// device name 
// 
char	inpfilenam[MAXPATHLEN] = 	// input file name	
         "fprg.bin";			// default input file name
// 
char	outfilenam[MAXPATHLEN] = 	// oupput file name 
         "fprg.out";			// default outpot file name
// 
char	protfilenam[MAXPATHLEN] = 	// protocol file mane
         "";				// default protocol file name

int	inspeed = 38400;		// baudrate
int     verbose = 0; 			// verbose mode 
int     erase_cmd = 0;			// erase command flag  
int     erase_sectors_cmd = 0;		// erase sector command
int     write_cmd = 0;			// write command flag 
int     read_cmd  = 0;			// read command flag
int     file_size = 0; 			// read/write file size 
int     hash = 0;			// 
int     block_size = 0;			// read & write block size
int     read_registers = 0;
int     dram_test_cmd = 0;
int     dram_byte_test_cmd = 0;
int     dram_halfword_test_cmd = 0;
int     dram_word_test_cmd = 0;
int     manufactory_cmd;		// read manufactory cmd 
int     deviceid_cmd = 0;		// read device id
int     fastwrite_cmd = 0;		// 
int     write_offset = 0; 		//  
int     write_speed = 0; 		//  
int     terminal_cmd = 0;		// terminal option 	
int     loopback_cmd = 0;		/* loopback command */
int     detach_cmd = 0;			/* detach command */
int     quiet_cmd = 0;			/* quiet mode */
int     terminal_hex_opt = 0;		// HEX terminal option 
int     echo_opt = 0;			// echo
int     echo_test_cmd = 0;		// tty ech test


///
#define FILE_SIZE_UPPER_LIMIT (2*1024*1024)


/* Prototypes */
static int setdevname (char *, int);
static int showversion(char **argv, int * arg_proc);
static int showhelp(char **argv, int * arg_proc);
static int showtodo(char **argv, int * arg_proc);
static int showchangelog(char **argv, int * arg_proc);
static int parseSectors(char **argv, int * argc);
static OPTION * find_option(char ** args, int * argc);

//////////////////////////////////////////////////////////////////////////////
// option definition /////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

OPTION general_options[] = 
{
//////////////////////////////////////////////////////////////////////////////
// read manufactory code ///////////////////////////////////////////////////// 
//////////////////////////////////////////////////////////////////////////////
 { 
  "terminal"			, 	// option name 
   OPT_INT | OPT_NO_ARG		, 	// option type
   & terminal_cmd		,	// pointer to option value (address)
  "ANSI/HEX Terminal"		, 	// option description  
   1				,	// option value
   0,0,					// upper_limit
   0
 },
 { 
  "loopback"			, 	// option name 
   OPT_INT | OPT_NO_ARG		, 	// option type
   & loopback_cmd		,	// pointer to option value (address)
  "Interface loopback test"	, 	// option description  
   1				,	// option value
   0,0,					// upper_limit
   0
 },
 { 
  "detach", 				/* option name */
   (OPT_INT | OPT_NO_ARG), 		/* option type */
   & detach_cmd,			/* pointer to option value (address) */
  "detach int Interface loopback test", /* option description */
   1				,	/* option value */
   0,0,					/* upper_limit */
   0
 },
 { 
  "hex"				, 	// option name 
   OPT_INT | OPT_NO_ARG		, 	// option type
   & terminal_hex_opt		,	// pointer to option value (address)
  "Terminal HEX mode option"	, 	// option description  
   1				,	// option value
   0,0,					// upper_limit
   0
 },
 { 
  "echo"			, 	// option name 
   OPT_INT | OPT_NO_ARG		, 	// option type
   & echo_opt			,	// pointer to option value (address)
  "Terminal echo option"	, 	// option description  
   1				,	// option value
   0,0,					// upper_limit
   0
 },
//////////////////////////////////////////////////////////////////////////////
// read manufactory code ///////////////////////////////////////////////////// 
//////////////////////////////////////////////////////////////////////////////
 { 
  "manufactory"			, 	// option name 
   OPT_INT  | OPT_NO_ARG	, 	// option type
   & manufactory_cmd		,	// pointer to option value (address)
  "Read Flash manufactory code"	, 	// option description  
   1				,	// option value
   0,0,					// upper_limit
   0
 },
//////////////////////////////////////////////////////////////////////////////
// read device id //////////////////////////////////////////////////////////// 
//////////////////////////////////////////////////////////////////////////////
 { 
  "device id"			, 	// option name 
   OPT_INT | OPT_NO_ARG		, 	// option type
   & deviceid_cmd		,	// pointer to option value (address)
  "Read Flash Device Id"	, 	// option description  
   1				,	// option value
   0,0,					// upper_limit
   0
 },
//////////////////////////////////////////////////////////////////////////////
// erase command ///////////////////////////////////////////////////////////// 
//////////////////////////////////////////////////////////////////////////////
 { 
  "erase"			, 	// option name 
   OPT_INT | OPT_NO_ARG		, 	// option type
   & erase_cmd			,	// pointer to option value (address)
  "Erase Flash" 		, 	// option description  
   1				,	// option value
   0,0,					// upper_limit
   0
 },
//////////////////////////////////////////////////////////////////////////////
// erase sectors ///////////////////////////////////////////////////////////// 
//////////////////////////////////////////////////////////////////////////////
 { 
  "erase sector"		, 	// option name 
   OPT_FUNC			, 	// option type
   (void *) parseSectors	,	// pointer to option value (address)
  "Erase Flash Sectors (0,1,2...)", 	// option description  
   0				,	// option value
   0,0,					// upper_limit
   0
 },
 { 
//////////////////////////////////////////////////////////////////////////////
// read comand ///////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
  "read"			, 	// option name   
   OPT_INT  | OPT_NO_ARG	, 	// option type 
   & read_cmd			,	// pointer to option value 
  "Read Flash" 			, 	// option description  
   1				,	// option value
   0,0,					// upper_limit
   0
 },
 { 
//////////////////////////////////////////////////////////////////////////////
// write flash command ///////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
  "bwrite"			, 	// option name   
   OPT_INT | OPT_NO_ARG		, 	// option type 
   & write_cmd			,	// pointer to option value 
  "Byte Write Flash" 		, 	// option description  
   1				,	// option value
   0,0,					// upper_limit
   0
 },
 { 
//////////////////////////////////////////////////////////////////////////////
// 
//////////////////////////////////////////////////////////////////////////////
  "write"			, 	// option name   
   OPT_INT | OPT_NO_ARG		, 	// option type 
   & fastwrite_cmd		,	// pointer to option value 
  "Block Write Flash" 		, 	// option description  
   1				,	// option value
   0,0,					// upper_limit
   0
 },
 { 
//////////////////////////////////////////////////////////////////////////////
// read registers command ////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
  "registers"			, 	// option name   
   OPT_INT | OPT_NO_ARG		, 	// option type 
   & read_registers		,	// pointer to option value 
  "Read Registers" 		, 	// option description  
   1				,	// option value
   0,0,					// upper_limit
   0
 },
//////////////////////////////////////////////////////////////////////////////
// file size ///////////////////////////////////////////////////////////////// 
//////////////////////////////////////////////////////////////////////////////
 { 
  "size"			, 	// option name   
   OPT_INT | OPT_LOW_LIMIT | OPT_UPPER_LIMIT, 	// option type 
   & file_size			,	// pointer to option value 
  "Size for read/write" 	, 	// option description  
// flags /////////////////////////////////////////////////////////////////////
   0				,
   1,FILE_SIZE_UPPER_LIMIT	,	// lower limit, upper_limit
   0
 },
//////////////////////////////////////////////////////////////////////////////
// flash write offset ////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
 { 
  "offset"			, 	// option name   
   OPT_U32 | OPT_LOW_LIMIT | OPT_UPPER_LIMIT, 	
   & write_offset		,	// pointer to option value 
  "Flash offset for write" 	, 	// option description  
// flags /////////////////////////////////////////////////////////////////////
   0				,
   0,FILE_SIZE_UPPER_LIMIT	,	// lower limit, upper_limit
   0
 },
//////////////////////////////////////////////////////////////////////////////
// flash write speed /////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
 { 
  "write speed"			, 	// option name   
   OPT_U32 | OPT_LOW_LIMIT | OPT_UPPER_LIMIT,
   & write_speed		,	// pointer to option value 
  "Baudrate for flash write" 	, 	// option description  
// flags /////////////////////////////////////////////////////////////////////
   0				,
   0,FILE_SIZE_UPPER_LIMIT	,	// lower limit, upper_limit
   0
 },
//////////////////////////////////////////////////////////////////////////////
// speed ///////////////////////////////////////////////////////////////////// 
//////////////////////////////////////////////////////////////////////////////
 { 
  "speed"			, 	// option name   
   OPT_INT			, 	// option type 
   & inspeed			,	// pointer to option value 
  "Speed (default value 38400)"	, 	// option description  
// flags /////////////////////////////////////////////////////////////////////
   0				,	// lover/upper limit are not valid
   0,0,					// lower limit, upper_limit
   0
 },
 { 
//////////////////////////////////////////////////////////////////////////////
// DRAM test command /////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
  "dram test"			, 	// option name   
   OPT_INT | OPT_NO_ARG		, 	// option type 
   & dram_test_cmd 		,	// pointer to option value 
  "DRAM test"	 		, 	// option description  
   1				,	// option value
   0,0,					// upper_limit
   0
 },

 { 
  "dram byte test"		, 	// option name   
   OPT_INT | OPT_NO_ARG		, 	// option type 
   & dram_byte_test_cmd 	,	// pointer to option value 
  "DRAM Byte read & write test"	, 	// option description  
   1				,	// option value
   0,0,					// upper_limit
   0
 },
 { 
  "dram half word test"		, 	// option name   
   OPT_INT | OPT_NO_ARG		, 	// option type 
   & dram_halfword_test_cmd 	,	// pointer to option value 
  "DRAM half word read & write test"	, 	// option description  
   1				,	// option value
   0,0,					// upper_limit
   0
 },
 { 
  "dram word test"		, 	// option name   
   OPT_INT | OPT_NO_ARG		, 	// option type 
   & dram_word_test_cmd 	,	// pointer to option value 
  "DRAM word read & write test"	, 	// option description  
   1				,	// option value
   0,0,					// upper_limit
   0
 },
 { 
  "echo test"			, 	// option name   
   OPT_INT | OPT_NO_ARG		, 	// option type 
   & echo_test_cmd 		,	// pointer to option value 
  "tty echo test"		, 	// option description  
   1				,	// option value
   0,0,					// upper_limit
   0
 },
//////////////////////////////////////////////////////////////////////////////
// read & write block size ///////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
 { 
  "block size"			, 	// option name   
   OPT_INT | OPT_LOW_LIMIT | OPT_UPPER_LIMIT,
   & block_size			,	// pointer to option value 
  "Read & Write block size" 	, 	// option description  
// flags /////////////////////////////////////////////////////////////////////
   0				,
   1,1024			,	// lower limit, upper_limit
   0
 },
 { 
//////////////////////////////////////////////////////////////////////////////
// write flash command ///////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
  "hash"			, 	// option name   
   OPT_INT | OPT_NO_ARG		, 	// option type 
   & hash			,	// pointer to option value 
  "Hash" 			, 	// option description  
   1				,	// option value
   0,0,					// upper_limit
   0
 },
//////////////////////////////////////////////////////////////////////////////
// input file name /////////////////////////////////////////////////////////// 
//////////////////////////////////////////////////////////////////////////////
 { 
  "input"			, 	// option name   
   OPT_STAT_STRING		, 	// option type 
   inpfilenam			,	// input file name buffer
// option description //////////////////////////////////////////////////////// 
  "Input file name for write operation",
// flags ///////////////////////////////////////////////////////////////////// 
   0				,       // inpfilenam - static buffer
   0				,	// lower limit for input file name
   sizeof(inpfilenam)		,	// sizeof input file name fuffer
   0
 },
//////////////////////////////////////////////////////////////////////////////
// output file name ////////////////////////////////////////////////////////// 
//////////////////////////////////////////////////////////////////////////////
 { 
  "output"			, 	// option name   
   OPT_STAT_STRING		, 	// option type 
   outfilenam			,	// output file name bufer 
// option description //////////////////////////////////////////////////////// 
  "Output file name for read operation",
// flags /////////////////////////////////////////////////////////////////////
   0				,       // outfilenam - static buffer
   0				,	// lower limit for input file name
   sizeof(outfilenam)		,	// sizeof input file name fuffer
   0
 },
 { 
//////////////////////////////////////////////////////////////////////////////
// protocol file name ////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
  "protocol"			, 	// option name   
   OPT_STAT_STRING		, 	// option type 
   protfilenam			,	// output file name bufer 
// option description //////////////////////////////////////////////////////// 
  "Terminal protocol file name (defaul = fprg.txt)",
// flags /////////////////////////////////////////////////////////////////////
   0				,       // outfilenam - static buffer
   0				,	// lower limit for input file name
   sizeof(protfilenam)		,	// sizeof input file name fuffer
   0
 },
 { 
//////////////////////////////////////////////////////////////////////////////
// show version //////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
  "--version"			, 	// variable name
   OPT_FUNC			, 	// variable type
   (void *) showversion		,	// pointer to option value 		
  "Show Version" 		,	// option description 
   0,					// flags
   0,0,					// upper_limit, lover_limit 
   0
 },
 { 
/* print todo and exit */
  "--todo", 				/* variable name */
   OPT_FUNC, 				/* variable type */
   (void *) showtodo,			/* pointer to option value */
  "print TODO note",			/* option description */
   0,					/* flags */
   0,0,					/* upper_limit, lover_limit */
   0
 },
 { 
/* print Change Log and exit */
  "--changelog", 			/* variable name */
   OPT_FUNC, 				/* variable type */
   (void *) showchangelog,		/* pointer to option value */
  "print Change Log note",		/* option description */
   0,					/* flags */
   0,0,					/* upper_limit, lover_limit */
   0
 },
 { 
//////////////////////////////////////////////////////////////////////////////
  "--help"			, 	// variable name
   OPT_FUNC			, 	// variable type
   (void *) showhelp		,	// pointer to option value 
  "Help"			,  	// option description 
   0,					// flags
   0,0,					// upper_limit, lover_limit
   0
 },
 { 
//////////////////////////////////////////////////////////////////////////////
  "-h"				, 
   OPT_FUNC			, 
   (void *) showhelp		,
  "Help"			,  	// option description 
   0,					// flags
   0,0,					// upper_limit, lover_limit
   0
 },
 { NULL }
};

////////////////////////////////////////////////////////////////////////////// 
// print version and exit ////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////// 

static int showversion(char **argv, int * arg_proc)
{
 fprintf (
   stdout			, 	
   "Version FPRG %s.%d%s\n"	,
    FPRG_VERSION		, 	// version 
    FPRG_PATCHLEVEL		, 	// patch level  
    FPRG_IMPLEMENTATION			// implementation 
  );
 exit(0);
 return(0);
}

/* */
static int showtodo(char **argv, int * arg_proc)
{
 fprintf(
   stdout,
   "TODO\n"
   "- loopback mode\n"
   "\n"
  );
 exit(0);
 return(0);
}

/* */
static int showchangelog(char **argv, int * arg_proc)
{
 fprintf(
   stdout,
   "Change Log\n"
   "- 2009\\09\\20 add loopback, detach options\n"
   "\n"
  );
 exit(0);
 return(0);
}

////////////////////////////////////////////////////////////////////////////// 
////////////////////////////////////////////////////////////////////////////// 
////////////////////////////////////////////////////////////////////////////// 


static int showhelp(char **argv, int * arg_proc)
{
 usage();
 exit(0);
 return 0;
}

static int parseSectors(char **argv, int * argc)
{
 if(argv == 0 || argc == 0)
  { 
   return(0);
  } 

 char * arg = *argv;			
 erase_sectors_cmd = 0;		

 while(1)
  {
   while(*arg == ' ' || *arg == ',')
    {					
     arg++;				
    }

   int pres;
   int val;

// 
   pres = 0;
   val = 0;
   while(*arg >= '0' && *arg <= '9')
    {
     pres = 1;
     val = val * 10 + (*arg - '0');
     arg++;
    }

   if(pres == 1)
    {
     if(val >= 0 && val < 32)
      {
       erase_sectors_cmd |= (1 << val);	
      }
    }

   if(*arg == '\0')
    {
     break;
    }    
  }
 
//
 *argc = 1;
 return(1);
}

static char *usage_string = "\
FPRG %s.%d%s %s\n\
 %s [ options ] ttyname, where :\n\
 ttyname is ttyS0 or ttyS1\n\
";

void usage(void)
{
 fprintf
  (
   stdout		, 		
   usage_string		, 		// 
   FPRG_VERSION		, 		// version 
   FPRG_PATCHLEVEL	, 		// patch level
   FPRG_IMPLEMENTATION	,		// implementation 
   FPRG_COPYRIGHT       ,
   "fprg"				// programm name
  );
// calc width of column "Option name"
 int namlen;				// length of name column 
 int optcnt;				// option count 
 int len;

 namlen = 0; 				// start name column length 
 optcnt = 0;				// start option count

// 
 OPTION * opt;  	
 for(opt = general_options; opt->name != 0; ++opt)  					//  
  {
   len = strlen(opt->name)+1;		// start name length 
   if(len > namlen)
    {					// reset name column 
     namlen = len;			// length 
    }
   optcnt++;				// option count 
  }

//
 if(optcnt <= 0)
  {					
// program has no options
   return;
  } 

// print option table titles 
 char * namtit = "Option name ";
 len = strlen(namtit);
 if(namlen < len) {namlen = len;}
 fprintf(stdout, "\n%s", namtit);	// print option name title
 while(len++ < namlen) 
  {
   fprintf(stdout," ");
  }					// print title padding
 fprintf(stdout, "Option description");
 
// print options & option description 
 for(opt = general_options; opt->name != 0; ++opt)  					//  
  {
   fprintf(stdout, "\n");		// move to new line	
// print option name 
   fprintf(stdout, "%s ", opt->name);	// print opt name word
   len = namlen - strlen(opt->name)-1;	// option name length 
// print column padding 
   while(len-- >0) { fprintf(stdout," "); }
   if(opt->description == 0)
    {					// null pointer to option description 
     continue;				// => move to next option 
    }     
   
// print option description 

   char * str;				// 
   str = opt->description;		// option description 
   while(1)
    {
     char * end;
     end = strchr(str, '\n');		// search new line
     if(end == 0)
      {					// new line not found 
       fprintf(stdout,str);		// 
       break;
      }

     while(str != end)
      {					
       fprintf(stdout, "%c", *str);
       str++;
      }
     str++;				// skip new line
     fprintf(stdout, "\n");		
     if(*str == '\0')
      {
       break;
      }

     for(len = namlen; len > 0; len--)
      {					// print column padding
       fprintf(stdout, " ");
      }
    }    
  }    
}


static int option_error(OPTION * opt, char *fmt, ...)
{
 va_list args;			
 char buf[512];				// temp buffer 	
 int pos;				// position in buf

//
 if(opt != 0 && opt->name != 0)
  {
   snprintf(buf, sizeof(buf), "Option [%s] error:",opt->name);
  }
 else
  {
   snprintf(buf, sizeof(buf), "Logview:");
  }
 pos = strlen(buf);

#if __STDC__
 va_start(args, fmt);
#else
 char *fmt;
 va_start(args);
 fmt = va_arg(args, char *);
#endif

 vsnprintf
  (
   buf + pos		, 	
   sizeof(buf) - pos	,
   fmt			, 	
   args			
  );
// 
 va_end(args);
 fprintf(stderr, "\n%s\n", buf);
 return(1);
}

/* */ 

static int setdevname(char * cp, int quiet)
{
 if(*cp == 0) {
    return(0);
 }

//  
 if(
    (strcmp(cp, "ttyS") == 0) ||
    (strcmp(cp, "/dev/ttyS") == 0)
 ) {
/* set device name */
    snprintf(devnam, sizeof(devnam), "%s", "/dev/ttyS");
 } else {
    char dev[MAXPATHLEN];			/* device name buffer */
    if(strncmp("/dev/", cp, 5) != 0)  {
	snprintf(
	    dev,			/* device name buffer */
	    sizeof(dev),		/* buffer size */
	    "/dev/%s", 			/* format */ 
	    cp				/* device name */
	);
	cp = dev;			/* reset device name */
    }

    struct stat statbuf;
    if(stat(cp, &statbuf) < 0) {
	if((errno == ENOENT) || quiet) {
	    return(0);
	}

	option_error(0, "stat() call error  %s: %m", cp);
	return(-1);
    }

/* set device name */
    snprintf(devnam, sizeof(devnam), "%s", cp);
 }
 return(1);
}

//////////////////////////////////////////////////////////////////////////////
// find option in option array ///////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

// return option pointer, argc - increment in args (length in words of option name)

static OPTION * find_option(char ** args, int * argc)
{
 if(args == 0 || argc == 0)
  {
   return(0);
  } 

//
 OPTION * fopt;				// find option 
 int fcnt;				// find option name len (words)

// 
 fopt = 0;
 fcnt = 0;

//  
 OPTION * opt;				// current option 
 for(opt = general_options; opt->name != 0; ++opt)
  {
   char **argv;
   char * str;
   int argn;

   str = opt->name;			// option name 
   argv = args;				// args
   argn = 0; 				// argument count 
   while(*str != '\0' && *argv != 0)
    {
     char * end;
     end = strchr(str, ' ');		// search space 
     if(end == 0)
      {
       if(strcmp(str,*argv) == 0)
        {
         if(++argn > fcnt)
          {
           fopt = opt;
           fcnt = argn;
          }
	}     
       break;
      }
 
     int len;
     len = end - str;
     if((int) strlen (*argv) != len || strncmp(str, *argv, len) != 0)
      {
       break;
      }
 
     argn++;
     argv++;
     str = end + 1;
    }
  }    

// 
 *argc = fcnt; 				// save option length 
 return(fopt);				// return find option 
}


//////////////////////////////////////////////////////////////////////////////
// process option ////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

static int process_option(OPTION * opt, char **argv, int * arg_proc)
{
 if(
   opt      == 0 || 			// null pointer to option 
   argv     == 0 || 			// null pointer to arguments 
   arg_proc == 0			// null pointer to number of processed arguments
  )
  {	
   return(0);
  } 

//
 *arg_proc = 0;

// extract option type 
 int type = (opt->type &  OPT_TYPE_MASK);

 if(
   type == OPT_U32 || 		// pointer to U32 
   type == OPT_U16 ||		// pointer to U16	
   type == OPT_U8		// pointer to U8
  )
  {
// U32, U16, U8 //////////////////////////////////////////////////////////////
   if(opt->type & OPT_NO_ARG) 
    {
// option has no args  
     *arg_proc = 0;
//
     switch(type)
      {
       case OPT_U32 : *((U32 *) (opt->addr)) = (U32) opt->value; break;
       case OPT_U16 : *((U16 *) (opt->addr)) = (U16) opt->value; break;
       case OPT_U8  : *((U8  *) (opt->addr)) = (U8 ) opt->value; break;
       default      :
        return(0);
      }	

     return(1);
    }

// U8, U16, U32 take 1 arg 
   char * str;
   str = *argv;
   if(str == 0)
    { 
     option_error(opt, "Option requery parameter");
     exit(1);
     return(0);
    }  

// skip start spase 
   while(*str == ' ' || *str == '\t') { ++str; } 
  
  //
   int base = 10;			// 
   if(*str == 'x' || *str == 'X')
    {
     str++;				// skip x
     base = 16;				// hex
    }
   else
   if(*str == '0' && (*(str + 1) == 'x' || *(str + 1) == 'X'))
    {
     str += 2;				// skip 0x
     base = 16;				// hex
    }   
   else 
   if((opt->type & OPT_HEX))
    {
     base = 16;				// 
    } 

//
   char * ptr;				// parse pointer 
   U32 val;				// result value 
   val = strtoul(str, &ptr, base);	// parse string str
   if(ptr == str) 
    {
     option_error
      (
       opt	,
      "Invalid argument (must be number) '%s'", 
       str
     );
// 
     exit(1);	
    }

   switch(type)
    {
     case OPT_U32 : *((U32 *) (opt->addr)) = (U32) val; break;
     case OPT_U16 : *((U16 *) (opt->addr)) = (U16) val; break;
     case OPT_U8  : *((U8  *) (opt->addr)) = (U8)  val; break;
     default      :
      fprintf(stderr,"\nInternal error\n");
      exit(1);
    }

// 
  *arg_proc = 1;			// argument count
   return(1);				
// end U32, U16, U8 //////////////////////////////////////////////////////////
  }

 if(type == OPT_STAT_STRING)
  {
// copy string argument to static buffer /////////////////////////////////////
   if(*argv == 0)
    {					// empty option argument
      option_error
       (
         opt	,			
	"Option requery parameter."
       );
     *arg_proc = 0;
      exit(1);
    } 

   char * str = (char *)(opt->addr);
   int pos = 0;				// current position 
   while(1)
    {
     if(pos + 1 >= opt->upper_limit)
      {
// out off destination destination buffer ////////////////////////////////////
       *(str + pos) = '\0';		
         break;
      }

// 
     *(str + pos) = *(*argv + pos);
     if(*(str + pos) == '\0')
      {
       break;
      }
//
     pos += 1;
    }

//
   *arg_proc = 1;
    return(1);
  }

 if(type == OPT_DUP_STRING)
  {
//////////////////////////////////////////////////////////////////////////////
   char * sv;
   sv = strdup(*argv);
   if (sv == NULL)
    {
     fprintf(stderr,"Memory alloc error\n");
     exit(1);
    }
   *(char **)(opt->addr) = sv;
   *arg_proc = 1;
    return(1);
  }

 if(type == OPT_FUNC)
  { 
// addr is pointer to void (*)(int,char **)
//////////////////////////////////////////////////////////////////////////////
   int (*parser)(char **, int *);
   parser = (int (*) (char **, int *)) opt->addr;
   if(parser == 0)
    {
     fprintf(stderr,"Internal error\n");
     exit(1);
    }

//
   *arg_proc = 0;   
   if((*parser)(argv, arg_proc) == 0)
    {
     return(0);
    }
//
   return(1);
  }

 if(type == OPT_INT)
  { 
//////////////////////////////////////////////////////////////////////////////
// addr is pointer to int ////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

   if((opt->type & OPT_NO_ARG)) 
    {
// option has no args ////////////////////////////////////////////////////////
     *(int *)(opt->addr) = (int) opt->value;
//
     *arg_proc = 0; 
      return(1);
    }

// option has arguments /////////////////////////////////////////////////////

   char * str;
   str = *argv;				// readoption arg
   if(str == 0)
    {
      option_error
       (
         opt	,			
	"Option requery parameter."
       );
     *arg_proc = 0;
      exit(1);
    }     
 
 // skip start spase 
   while(*str == ' ' || *str == '\t') { ++str; } 
  
  //
   int base = 10;			// 
   if(*str == 'x' || *str == 'X')
    {
     str++;				// skip x
     base = 16;				// hex
    }
   else
   if(*str == '0' && (*(str + 1) == 'x' || *(str + 1) == 'X'))
    {
     str += 2;				// skip 0x
     base = 16;				// hex
    }   
   else 
   if((opt->type & OPT_HEX))
    {
     base = 16;				// 
    } 

 
 // 
   char * ptr;				// parse pointer 
   int val;				// result value 
   val = strtol(str, &ptr, base);	// parse sp
   if(ptr == str) 
    {
// parse error 
     option_error
      (
       opt	,
      "Invalid argument (must be number) '%s'", 
       str
     );
     exit(1);	
    }

// check low limit, upper limit, zero ok condition 
   if( 
      (
       ((opt->type & OPT_LOW_LIMIT  ) && val < opt->lower_limit) || 
       ((opt->type & OPT_UPPER_LIMIT) && val > opt->upper_limit)
      )
       && (((opt->type & OPT_ZERO_OK) && val == 0) == 0)
    ) 
    {
//  
     char * zok = (char *)( (opt->type & OPT_ZERO_OK)? " zero or": "");
     switch(opt->type & OPT_LIMITS) 
      {
       case OPT_LOW_LIMIT	:
        option_error
         (
           opt			,
          "must be%s >= %d"	,
	   zok			, 
	   opt->lower_limit
	 );
	break;

       case OPT_UPPER_LIMIT	:
	option_error 
	 (
	   opt			,
	  "must be%s <= %d"	,
	   zok			,
	   opt->upper_limit
	 );
	break;

       case OPT_LIMITS	:
        option_error
         ( 
           opt			,
          "must be >= %d and <= %d",
           opt->lower_limit	, 
           opt->upper_limit
         );
        break;
      }

     exit(1);
    }

// end of int option ///////////////////////////////////////////////////////// 
   *(int *)(opt->addr) = val;
   *arg_proc = 1;    
   return(1);
  }

// 
 return(1);
}

/////////////////////////////////////////////////////////////////////////////
// read options from file ///////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

int options_from_file(char * filename)
{
 if(filename == 0)
  {					// null pointer to	
   return(0);				// file name 
  } 

// 
 FILE * file;				// 
 file = fopen(filename, "r");
 if(file == 0)
  { 
// not error 
   return(0);
  }

//   
 char buf[512];				// work buffer 
 int line;				// line number

//
 line = 0;

// 
 while(feof(file) == 0) 
  {
   char ch;				// readed byte 
   int pos;				// buffer position
//   
   pos = 0;   				// start position 
   ch = fgetc(file);			// read byte 
   while(feof(file) == 0)
    {
     if(ch == '\n')
      {					// find line terminator 
       break;
      }

     if(pos + 1 == sizeof(buf))
      {
// out of work buffer => search line terminator 
       ch = fgetc(file);
       while(feof(file) == 0 && ch != '\n')
        {
	 ch = fgetc(file);
	} 
//
       break;
      }

     if(ch == '#')
      {
// comment => search line terminator   
       ch = fgetc(file);
       while(feof(file) == 0 && ch != '\n')
        {
	 ch = fgetc(file);
	} 
       break;
      }

// 
// convert tab to space   
     if(ch == '\t')
      {		
       ch = ' ';
      } 

     if(ch == ' ')
      {
       if(pos > 0 && buf[pos - 1] == ' ')
        {
         ch = fgetc(file);
	 continue;
        }
      }

     buf[pos++] = ch;
     ch = fgetc(file);
    }   

   if(pos >= (int) sizeof(buf)) 
    {
     fprintf
      (
       stderr	,
       "\nInternal error\n"
      ); 
     break;
    }

// string terminator 
   buf[pos] = '\0'; 

   char * argv[32];			
   int argc; 
//
   for(argc = 0; argc < 32; ++argc)
    {
     argv[argc] = 0;
    }

// 
   char * str = buf;			// item start 
   char * end;				// item end 
   argc = 0; 				// item count 
   while(strlen(str) != 0)		// while not empty string
    {
     end = strchr(str, ' ');		// search words separator 
     if(end == 0)
      {
// not found => write 
       if(argc < 32)
        {
         argv[argc++] = str;
	}
//
       break;
      }

// 
     *end = '\0'; 
     if(argc < 32) 
      {
       argv[argc++] = str;
      }
     str = end + 1;
    }     

   if(argc >= 32)
    {
     fprintf
      (
         stderr				 ,
       "\nFile [%s] line [%d] too long\n",
         filename			 ,
	 line
      ); 
     exit(1);
    }

// terminator of argumets  
   argv[argc] = 0;

   if(argc == 0)
    {
     continue;
    }   

// search option 
   int olen = 0;			// option length, words 
   OPTION * opt;			// option 
   opt = find_option(argv, & olen);	
   if(opt == NULL) 
    {
     option_error
      (
        0	,
       "File [%s] parse error. Line [%d]",
        filename,
        line
      );
     continue;
    }

   if(olen > argc)
    {
     fprintf(stderr,"\nInternal error\n");
     exit(1);
    }

// 
   int arg_proc = 0;
   if(
     process_option
      (
       opt	  , 
       argv + olen, 
       & arg_proc
      ) == 0
    )
    { 
     fclose(file);
     option_error
      (
       opt			,
       "Option parse error"
      );
// 
     exit(1);
    }


// calc line count 
   line += 1;				
  }

 fclose(file);
 return(1);
}

//////////////////////////////////////////////////////////////////////////////
// process command line args /////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

int parse_args(int argc, char ** argv)
{
 if(argv == 0)
  {		
   return(0);	
  } 

//  
 while(argc > 0)
  {
   int olen;				// option length 
   int alen;				// option args count 

   OPTION * opt;			// search option 
   olen = 0;				// clear option length 
   opt = find_option(argv, & olen);
   if(opt != 0)
    {
// option found 
     argv += olen;    			// move to opt arg
     argc -= olen;    			// remain strings
     alen = 0;

     if(
       process_option
        (
         opt	, 
         argv	,		 	
         &alen       
        ) == 0
     )
     {
      return(0);
     }

// 
     argv += alen;			// skip parsed argument
     argc -= alen;			// remain strings
     continue;				
    }

   int ret;
   if((ret = setdevname(*argv, 0)) == 0 ) 
    {
     option_error(0,"Unknown option '%s'", *argv);
     usage();
     return(0);
    }
   else
    {
     if(ret < 0)
      {
       return(0);
      }
     argv++;
     argc--;
    }
  }

// 
 return(1);
}

