#define _ASPLINUX_
#include <errno.h>			//
#include <ctype.h>			//
#include <fcntl.h>			//	
#include <pwd.h>			//	
#include <setjmp.h>			//		
#include <signal.h>			//
#include <stdio.h>			//
#include <stdlib.h>			//
#include <string.h>			//
#include <syslog.h>			//
#include <termios.h>			//
#include <unistd.h>			//
#include <utmp.h>			//

#include <sys/errno.h>			//
#include <sys/file.h>			//
#include <sys/ioctl.h>			//
#include <sys/param.h>			//
#include <sys/resource.h>		//
#include <sys/stat.h>			//
#include <sys/time.h>			//
#include <sys/types.h>			//
#include <sys/utsname.h>		//	
#include <sys/wait.h>			//

#ifdef _ASPLINUX_
#include <time.h>			//
#endif 

/*
 * (c) 2006-2009 Dmitriy I.Cherkashin, www.ucrouter.ru
 * email: dch@ucrouter.ru , divch@users.sourceforge.net , dch@ucrouter.com 
 * phone: +8-909-936-8809; ICQ: 474-363-900; AIM:divchaim; YAHOO:divchyah
 */

//#define TTY_DEBUG

#include <sys/socket.h>			/* socket connect setsockopt */
#include <netdb.h>			/* gethostbyname */
#include <netinet/in.h>			/* sockaddr_in */
#include <netinet/tcp.h>		/* TCP_NODELAY */
#include <arpa/inet.h>			/* inet_addr */

#include "fprg.h"	

// 
static int ttyfd[2]       = {-1, -1};	/* tty device descriptor */
static mode_t tty_mode[2] = {(mode_t)-1,(mode_t)-1}; /* */
static int kill_link      = 0;		/* */
struct termios restore_termios[2];	/* terminal settings */

//////////////////////////////////////////////////////////////////////////////
// SIGTERM/SIGINT ////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

static void term(int sig)
{
 printf("Received signal %d. Terminating.\n", sig);
 kill_link = 1;
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

static void bad_signal(int sig)
{
 fprintf(stderr,"Received unknown signal %d\n", sig);
 exit(1);
}

static void chld_signal(int sig)
{
}


//////////////////////////////////////////////////////////////////////////////

struct speed 
{
 int speed_int;	
 int speed_val;	
} 
 speeds[] = 
{
#ifdef B50
 { 50, B50 },	
#endif
#ifdef B75
 { 75, B75 },	
#endif
#ifdef B110
 { 110, B110 },	
#endif
#ifdef B134
 { 134, B134 },	
#endif
#ifdef B150
 { 150, B150 },	
#endif
#ifdef B200
 { 200, B200 },	
#endif
#ifdef B300
 { 300, B300 },	
#endif
#ifdef B600
 { 600, B600 },	
#endif
#ifdef B1200
 { 1200, B1200 },	
#endif
#ifdef B1800
 { 1800, B1800 },	
#endif
#ifdef B2000
 { 2000, B2000 },
#endif
#ifdef B2400
 { 2400, B2400 },
#endif
#ifdef B3600
 { 3600, B3600 },
#endif
#ifdef B4800
 { 4800, B4800 },
#endif
#ifdef B7200
 { 7200, B7200 },
#endif
#ifdef B9600
 { 9600, B9600 },
#endif
#ifdef B19200
 { 19200, B19200 },
#endif
#ifdef B38400
 { 38400, B38400 },	
#endif
#ifdef B57600
 { 57600, B57600 },	
#endif
#ifdef B115200
 { 115200, B115200 },	
#endif
#ifdef EXTA
 { 19200, EXTA },	
#endif
#ifdef EXTB
 { 38400, EXTB },	
#endif
#ifdef B230400
 { 230400, B230400 },	
#endif
#ifdef B460800
 { 460800, B460800 },	
#endif
 { 0, 0 }
};

//////////////////////////////////////////////////////////////////////////////
// return constand, defined in .H ////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

static int speed_toh(int bps)
{
 if(bps == 0) 
  {
   return(0);
  }

 struct speed *speedp;
 for(speedp = speeds; speedp->speed_int; speedp++) 
  {
   if(bps == speedp->speed_int)
    {
     return(speedp->speed_val);
    }
  }

//
 fprintf(stderr,"Speed %d not supported\n", bps);
 return(0);
}

//////////////////////////////////////////////////////////////////////////////

static int speed_tob(int speed)
{
 if(speed == 0) 
  {
   return(0);
  }
    
 struct speed *speedp;
 for(speedp = speeds; speedp->speed_int; speedp++) 
  {
   if (speed == speedp->speed_val)
    { 
     return(speedp->speed_int);
    }
  }

 return(0);
}

//////////////////////////////////////////////////////////////////////////////
// setdtr - control the DTR line on the serial port.//////////////////////////
// This is called from die(), so it shouldn't call die(). ////////////////////
//////////////////////////////////////////////////////////////////////////////

int setdtr(int fd, int on)
{
 int modembits = TIOCM_DTR;
 if(ioctl(fd, (on ? TIOCMBIS : TIOCMBIC), &modembits) < 0)
  {
   return(0);
  }  
 return(1);
}

/* init tty device */

int setup_tty(int ttyn, int local)
{
 if((ttyn < 0) || (ttyn >= 2)) {
    return(0);
 }

 if(ttyfd[ttyn] == -1) {
    return(0);
 }

 setdtr(ttyfd[ttyn], 1);				// 
 struct termios tios;			// tty settings
 if(tcgetattr(ttyfd[ttyn], &tios) < 0) {
    fprintf(
	stderr,
	"TTY device attribute read error (tcgetattr): (%d)\n", 
	errno
    );
    return(0);
 }

// save tty settings /////////////////////////////////////////////////////////
 restore_termios[ttyn] = tios;		//    

// clear control bits ////////////////////////////////////////////////////////
 tios.c_cflag &= ~(
    CSIZE  | 				/* byte suze mask */
    CSTOPB | 				/* 2 stop bits */
    PARENB | 				/* parity bit */
    CLOCAL
   );

// set control bits //////////////////////////////////////////////////////////
 tios.c_cflag   |= 
  CS8 		| 			// byte size=8
  CREAD 	| 			//
  HUPCL;				

#ifdef	IUCLC
 tios.c_iflag &=
   ~(
     ISTRIP	|		
     INLCR	|		
     IGNCR	|		
     ICRNL	|		
     IUCLC	|		
     IXON	|
     IXOFF	|
     IMAXBEL
    ) ;

#else
 tios.c_iflag &=
   ~(ISTRIP|INLCR|IGNCR|ICRNL|IXON|IXOFF|IMAXBEL) ;
#endif

 tios.c_iflag   |= 
  IGNBRK 	| 	
  IGNPAR;		

// 
 tios.c_oflag &= ~OPOST;

 tios.c_lflag      = 0;
 tios.c_cc[VMIN]   = 1;
 tios.c_cc[VTIME]  = 1;

 if(1) {
    tios.c_cflag |= CLOCAL;
    tios.c_cflag &=~HUPCL;
 }

 tios.c_cflag &= ~CRTSCTS;

//  
 int speed;		
 speed = speed_toh(inspeed);
 if(speed) {
    printf("Set speed=%d\n",inspeed); 
    cfsetospeed(&tios, speed);	
    cfsetispeed(&tios, speed);	
 } else {
    speed = cfgetospeed(&tios);
    printf("Used speed=%d\n",speed_tob(speed)); 
    if(speed == B0) {
	fprintf(stderr,"Speed fo %s = 0. Use commnad line to set speed.\n", devnam);
	exit(1);
    }
 }

 if(tcsetattr(ttyfd[ttyn], TCSAFLUSH, &tios) < 0) {
    fprintf(
	stderr,
	"TTY device set attribute error (tcsetattr)\n"
    );
    exit(1);
 }        
//
 inspeed = speed_tob(speed);
 return(1);
}

/* close tty device */

int close_tty(int ttyn)
{
 if((ttyn < 0) || (ttyn >= 2)) {
    return(0);
 }
 
 if(ttyfd[ttyn] == -1) {
    return(0);
 } 

//
 int rvl;
//
 rvl = 1; 
 
 if(tcsetattr(
    ttyfd[ttyn], 
    TCSAFLUSH, 
    & restore_termios[ttyn]
 ) < 0) {
    rvl = 0;
    printf("Can not restore TTY device attribute\n");
 }

// 
 if(tty_mode[ttyn] != (mode_t) -1) {
    if(fchmod(ttyfd[ttyn], tty_mode[ttyn]) != 0) {
	if(chmod(devnam, tty_mode[ttyn]) != 0) {
	    rvl = 0; 
	}
    }
 }    

// 
 close(ttyfd[ttyn]);
 ttyfd[ttyn] = -1;
 return(rvl);
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

//
// p     = buffer pointer
// len   = data length
// sec   = delay sec
// ms    = delay ms

int write_tty(unsigned char * p, int len, int sec, int ms)
{
 if(
    p   == 0 ||				// null buffer pointer
    len < 0	
  )
  {
   return(0);
  } 

#ifdef TTY_DEBUG
     printf("<");
     int i;
     for(i = 0; i < len; ++i)
      {
       printf("%c[%02x]",p[i],p[i]);
      }
     printf("\n");
#endif
 
 int rvl;	
// 
 rvl = 1; 	

 while(len > 0)
  {
   int wlen;
   if(sec > 0 || ms > 0)
    {
     wlen = 1;
    }
   else
    {
     wlen = len;
    }

   if(
     write	
      (
       ttyfd[0]	, 
       p	,
       wlen	
      ) < 0
    ) 
    {
// write error ///////////////////////////////////////////////////////////////
     rvl = 0;				// clear return code 

//    
     if(errno == EWOULDBLOCK) 		
      {
       fprintf(stderr,"\nTTY device write error : EWOULDBLOCK");
      }
     else
     if(        
       errno == ENOBUFS	  || 		// 
       errno == ENXIO     || 
       errno == EIO       || 		// IO error
       errno == EINTR			// signal received 
      )
      {
       fprintf(stderr,"\nTTY device write error : (%d)", errno);
      }
     else
      {
       fprintf(stderr,"\nTTY device write error :(%d)", errno);
      }
//
     break;
    }

   p += wlen;
   len -= wlen; 
   if(sec > 0)
    {
     sleep(sec);			// sleep seconds
    } 
   else
    {
     usleep(ms*1000);			// sleep microseconds
    }    
  }

//
 return(rvl);				//    
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

int read_tty(unsigned char *buf, int len)
{
 int cnt;
 cnt = read(ttyfd[0], buf, len);
 if(cnt < 0) 
  {
   fprintf(stderr,"\nTYY device read error :(%d)", errno);
   exit(1);
  }

#ifdef TTY_DEBUG
 printf(">");
 int i;
 for(i = 0; i < cnt; ++i)
  {
   printf("%c[%02x]",buf[i],buf[i]);
  }
 printf("\n");
#endif

// 
 return(cnt);
}

//////////////////////////////////////////////////////////////////////////////
// read from tty device with timeout /////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

int read_tty(unsigned char * buf, int len, int sec)
{
 if(
   ttyfd[0] == -1 || 			//
   buf   ==  0 ||
   len   <=  0 || 
   sec   <=  0
  )
  {
// undefined tty descriptor //////////////////////////////////////////////////
   return(0);
  } 

// 
 static fd_set r_fds; 
 static int fd_zero = 1;		
 if(fd_zero == 1)
  {
   fd_zero = 0;
   FD_ZERO(&r_fds);
  }

// 
 int pos;				// 
 pos = 0;	

// 
 while(pos < len)
  {
   FD_SET(ttyfd[0], & r_fds);     

// 
   struct timeval tval;	
   tval.tv_sec  = 1;	
   tval.tv_usec = 0;	

// 
   int cnt;
   cnt = select
    (
     ttyfd[0] + 1	, 	
     & r_fds	, 	
      0	 	, 	
      0 	, 	
     & tval		
    );

// 
   if(cnt < 0 && errno != EINTR)
    {
     fprintf(stderr,"select error: (%d)\n", errno);
     return(0); 
    }

//
   sec -= 1;				// remain seconds

// 
   if(FD_ISSET(ttyfd[0],& r_fds))
    {
     cnt = read(ttyfd[0], buf + pos, len - pos);
     if(cnt < 0) 
      {
       fprintf(stderr,"TYY read error :(%d)\n", errno);
       return(0);  
      }

// 
#ifdef TTY_DEBUG
     printf(">");
     int i;
     for(i = 0; i < cnt; ++i)
      {
       printf("%c[%02x]",buf[pos+i],buf[pos+i]);
      }
     printf("\n");
#endif

     pos += cnt;
    }

   if(sec <= 0)
    {
     break;
    }
  }
// 
 if(pos < len) 
  {
   return(0);
  }
 else
  {
   return(1);
  }    
}

//////////////////////////////////////////////////////////////////////////////
// receive 'rr' (receive ready) //////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

int read_id(void)
{
 printf("Test link ...");
 fflush(stdout);

 u_short code;				// manufactory code & device ID
 u_char rbuf[32];			// read buffer 
 int cnt;
 
//
 code = 0;
 cnt = 20;
 while(cnt-- >= 0)
  {
   if(read_tty(rbuf,1,5) == 0)
    {
     if(kill_link == 1)
      {
       fprintf
        (
	 stderr	,
	 "\nTest Link terminated.\n"
        );
//
       exit(1);	
      }

     cnt = 0;
     break;
    } 
  
   code = (code << 8) | (u_short) (rbuf[0]);
   if(code ==  ( (((u_short)'r') << 8) | (u_short)('r')) )
    {
     printf("Ok\n");
     break;
    }
  }

 if(cnt <= 0)
  {
   printf("Fail\n");
   return(0);
  }

 return(1);
}

//////////////////////////////////////////////////////////////////////////////
// write data length /////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

int write_len(u_short prompt, int len, int ignorerepl=0)
{
 u_char rbuf[32];			// read buffer 
 u_short code;				// 
 int cnt;

// read file size prompt (FL) ////////////////////////////////////////////////
 code = 0;				// received 2 bytes
 cnt = 30;				// try count
 while(cnt-- >= 0)
  {
   if(read_tty(rbuf,1,3) == 0)
    {
     if(kill_link == 1)
      {
       fprintf
        (
	 stderr	,
	 "\nWrite Length terminated.\n"
        );
//
       exit(1);	
      }

     cnt = 0;
     break;
    } 

 
   code = (code << 8) | ((u_short)(rbuf[0]));
   if(code == prompt)
    {
     break;
    }
  }

 if(cnt <= 0)
  {
   printf("Fail\n");
   fprintf(stderr,"Data length prompt timeout\n");
   return(0);
  }

// 
 u_char wbuf[32];
 sprintf
  (
    (char *) wbuf 	,
   "%08X"		,
    len 
  );    

// write length //////////////////////////////////////////////////////////////

 if(write_tty(wbuf, 8, 0, 0) == 0)	/* DEBUG delay 1  */
  {
   fprintf
    (
      stderr,
     "Data length write error\n"
    );
   return(0);
  }

// read length ///////////////////////////////////////////////////////////////
 if(read_tty(rbuf, 8, 3) == 0)
  {
   if(ignorerepl == 1)
    {
     return(1);
    } 

   if(kill_link == 1)
    {
     fprintf
      (
          stderr	,
       "\nRead Length terminated\n"
      );
//
     exit(1);
    }

   fprintf
    (
      stderr	,
     "Data length read timeout\n"
    );
   return(0);
  }


// compare read length and writed length /////////////////////////////////////  

 int pos;
 for(pos = 0; pos < 8; ++pos)
  {
   if(rbuf[pos] >= 'a' && rbuf[pos] <= 'f')
    {
// convert to lover register ///////////////////////////////////////////////// 
     rbuf[pos] = (rbuf[pos] - 'a') + 'A';
    }

   if(wbuf[pos] != rbuf[pos])
    {
     if(ignorerepl == 1)
      {
       return(1);
      } 

     rbuf[8] = '\0';
     fprintf
      ( 
        stderr		,
       "Read data length [%8s] not equal writed [%8s]\n",
        rbuf		,
        wbuf
      );
     return(0);
    } 
  }

//
 return(1);
}

//////////////////////////////////////////////////////////////////////////////
// Erase Flash ///////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

int proc_Erase(void)
{
// Read "rr" (receive ready) ///////////////////////////////////////////////// 

 if(read_id() == 0)
  {
   return(0);
  }

 printf("Erase flash ...");
 fflush(stdout);

// write erase command (CE) //////////////////////////////////////////////////  
 u_char  buf[32];
 buf[0] = 'C';
 buf[1] = 'E';
 if(write_tty(buf,2,3,0) == 0)
  {
   return(0);
  }

// wait erase asc ////////////////////////////////////////////////////////////  

#define ERASE_OK  (((u_short)('O') << 8) | (u_short)('K'))
#define ERASE_CMD (((u_short)('C') << 8) | (u_short)('E'))
 u_short more; 
 u_short code;   			// rx buffer  
 int cnt ;
 more = 3;
 code = 0;				// clear rx buffer
 cnt = 30;
 while(cnt-- >= 0)
  {
// read char (taimaut = 3 sec) //////////////////////////////////////////////
   if(read_tty(buf,1,3) == 0)
    {
     if(kill_link == 1)
      {
       fprintf
        (
          stderr	,
         "\nFlash erase terminated."
        );
// 
       exit(1);
      }

// 
     continue;
    } 


//   
   code = (code << 8) | (u_short) (buf[0]);

// 
   if(code == ERASE_CMD)
    {
// received erase command reply ("CE") //////////////////////////////////////
     more &= ~1;			// clear erase command reply bit  
     code = 0;				// clear RX buffer 
    }
   else
   if(code == ERASE_OK)
    {
// received erase result ////////////////////////////////////////////////////
     more &= ~2;			// clear result bit 
     code = 0;				// clear RX buffer 
    }

   if(more == 0)
    {
// erase reply & result are received ////////////////////////////////////////
     break;
    }
  }

// 
 if(cnt > 0)
  {
   printf("Ok\n");
   return(1);
  }
 else 
  {
   printf("Fail\n");
   return(0);
  }
}

////////////////////////////////////////////////////////////////////////////// 
// erase sectors /////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////// 

int proc_EraseSectors(void)
{
// Read "rr" (receive ready) ///////////////////////////////////////////////// 

 if(read_id() == 0)
  {
   return(0);
  }

// 
 printf("\nErase flash sectors");
 fflush(stdout);

//
 int rvl;				// return code 
//
 rvl = 1; 

 int sn;				// sector nuber
 for(sn = 0; sn < 32; ++sn)
  {
   if( (erase_sectors_cmd & (1 << sn)) == 0 )
    {
     continue;
    } 

   printf("\n Sector %d ...", sn);
   fflush(stdout);

// write sector erase command (SE) ///////////////////////////////////////////  

   u_char  buf[32];
   buf[0] = 'S';			// sector erase 
   buf[1] = 'E';			// command
   if(write_tty(buf,2,3,0) == 0)
    {
     rvl = 0;				// clear return value
     break;
    }


#define ERASE_SECTOR_CMD (((u_short)('S') << 8) | (u_short)('E'))

   if(
      write_len				// write sector number 
       ( 
        ERASE_SECTOR_CMD,		// reply to write sector command 
        sn				// sector number
       ) == 0
    )
    {
     rvl = 0;				// clear return value
     break;
    } 

   u_short more; 
   u_short code;   			// rx buffer  
   int cnt ;

   more = 1;
   code = 0;				// clear rx buffer
   cnt = 30;
   while(cnt-- >= 0)
    {
// read char (timeout = 3 sec) ///////////////////////////////////////////////
     if(read_tty(buf,1,3) == 0)
      {
       if(kill_link == 1)
        {
         fprintf
          (
           stderr	,
          "\nFlash erase terminated."
         );
// 
         exit(1);
        }
// 
       continue;
      } 

printf("%c", buf[0]);
//   
     code = (code << 8) | (u_short) (buf[0]);

// 
     if(code == ERASE_OK)
      {
// received erase result ////////////////////////////////////////////////////
        more = 0;			// clear result bit 
        break;
      }
    }

   if(more == 1)
    {
     printf("Fail");
     rvl = 0;
     break;
    }
   else
    {
     printf("Ok");
    }    
  }

// 
 if(rvl)
  {
   printf("\nOk\n");
   return(1);
  }
 else 
  {
   printf("\nFail\n");
   return(0);
  }
}

//////////////////////////////////////////////////////////////////////////////
// write file to flash ///////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

int proc_Write(void)
{
//////////////////////////////////////////////////////////////////////////////
// open input file ///////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

 FILE * fi;
 fi = fopen(inpfilenam,"r+b"); 	
 if(fi == 0)
  {
   fprintf
    (
        stderr	,
     "\nInput file [%s] open error\n", 
       inpfilenam
    );
// 
   return(0);
  }

//////////////////////////////////////////////////////////////////////////////
// read sizeof input file //////////////////////////////////////////////////// 
//////////////////////////////////////////////////////////////////////////////

 int len;				// length 
 fseek(fi,0,SEEK_END);			// seek to file end
 len = ftell(fi);			// read position 
 if(len <= 0)
  {
   fclose(fi);
   fprintf
    (
       stderr,	
     "\nSize read of input file [%s] error\n", 
      inpfilenam
    );
   return(0);
  }

// 
 if(file_size == 0)
  {
// sizeof writed data is not defined in command line ////////////////////////
   file_size = len;			// = file length 
  }

// allocate buffer //////////////////////////////////////////////////////////
 u_char * buffer;
 buffer = new u_char [len];
 if(buffer == 0)
  {
   fclose(fi);
   fprintf
    (
       stderr	,
     "\nBuffer alloc error [%d][0x%x]\n", 
       len,
       len
    );
   return(0);
  }

// read input file to buffer ////////////////////////////////////////////////
 fseek(fi,0,SEEK_SET);			// to file begin 
 int pos;				// current position in file  	
 pos = 0;				// start position 
 while(feof(fi) == 0)
  {
// read char from file //////////////////////////////////////////////////////

   u_char ch;
   if(fread( &ch, sizeof(ch), 1, fi) < 1)
    {
// read file error //////////////////////////////////////////////////////////
     if(feof(fi))
      {
// eof //////////////////////////////////////////////////////////////////////  
       if(pos >= len)
        {
         break;
        }
      } 

     fprintf
      (
        stderr		,
       "\nFile [%s] read error, position [%d,%x]\n", 
        inpfilenam	,
        pos 		,		
	pos  
      );

// 
     delete buffer;			// free allocated buffer
     fclose(fi);			// close open file 
     return(0);  
    } 

   if(pos < len)
    {
     buffer[pos] = ch;
     pos += 1;
    } 
   else
    {
// 
     fprintf
      (
        stderr	,
       "\nInternal file read error [%s]\n", 
        inpfilenam
      );

// 
     fclose(fi);
     return(0);  
    }
  }
//
 fclose(fi);

// read receive ready prompt ////////////////////////////////////////////////

 if(read_id() == 0)
  {
   delete buffer;			// free allocated buffer 
   return(0);
  }

// write command (WR) ///////////////////////////////////////////////////////

 printf("Write flash ...");
 fflush(stdout);

// 
 u_char wbuf[32];
 wbuf[0] = 'W';
 wbuf[1] = 'R';
 if(write_tty(wbuf,2,3,0) == 0)
  {
   delete buffer;			// free allocated buffer
   return(0);
  }

// write data length ////////////////////////////////////////////////////////

 if(
    write_len
     ( 
      ((((u_short)'W')<<8) | 'R'),	// reply to write cmd 
          file_size			// data length 
     ) == 0
  )
  {
   delete buffer;			// free allocated buffer
   return(0);
  } 

// write data ////////////////////////////////////////////////////////////////

 if(block_size <= 1)
  {
//////////////////////////////////////////////////////////////////////////////
// block size = 1 byte ///////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

   for(pos = 0; pos < len; ++pos)
    {
     if(pos >= file_size)
      {
       break;
      } 
  
     if(hash != 0)
      {
       if(pos > 0 && (pos % 1024) == 0)
        {
         fprintf(stdout, "#");
         fflush(stdout);       
        }
      } 

// write byte ////////////////////////////////////////////////////////////////

     if(write_tty(buffer + pos, 1, 0, 0) == 0)
      {
// write byte error //////////////////////////////////////////////////////////
       fprintf
        (
	  stderr	,
	 "\ntty write error, position [%d][0x%x], byte [0x%02x]\n",

          pos		,		// position in decimal format 
          pos 		,		// position in hex format 	
        *(buffer + pos)			// writed char 
       );

//
       delete buffer;			// delete allocated buffer
       return(0);
      }

// read byte /////////////////////////////////////////////////////////////////

     u_char rbuf[32];
     rbuf[0] = 0;
     if(read_tty(rbuf, 1, 10) == 0)
      {
       if(kill_link == 1)
        {
         fprintf
          (
            stderr	,
           "\nFlash write terminated."
          );
// 
         exit(1);
        }

// 
       fprintf
        (
	   stderr,
	 "\nTimeout for read writed byte\n"
	);

// 
       return(0);
      }


     if(rbuf[0] != buffer[pos])
      {
       fprintf
        ( 
          stderr		,
         "\nRead byte [0x%02x] is not equal writed byte [0x%02x],"
         "position [%d][0x%x]\n"	,
          rbuf[0] 		,
          buffer[pos]		,
          pos			,
         pos
        );

// 
       delete buffer;			// delete allocated buffer
       return(0);
      }
    }
  }
 else
  {
//////////////////////////////////////////////////////////////////////////////
// read/write block size > 1 byte ////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

   int last_hash; 			// previous hash position  
   last_hash = 0; 			// 

// 
   pos = 0;				// current write position
   while(pos < len)
    {
     if(pos >= file_size)
      {
// out off file size /////////////////////////////////////////////////////////
       break;
      } 
  
     if(hash != 0)
      {
// defined hash character ////////////////////////////////////////////////////
       if(pos > 0 && (pos >= last_hash + 1024))
        {
// hassh block is writed /////////////////////////////////////////////////////
         last_hash = pos;		// reset hash position 
         fprintf(stdout, "#");		// out hash character 
         fflush(stdout);       		// flush stdout
        }
      } 

//////////////////////////////////////////////////////////////////////////////
// write block ///////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

     int wlen;				// write len
     if(pos + block_size <= len)
      {
       wlen = block_size;
      }
     else
      {
       wlen = len - pos;
      }

     if(wlen > 1024)
      {
       wlen = 1024;
      } 

     if(write_tty(buffer + pos, wlen, 0, 10) == 0)
      {
       fprintf
        (
	  stderr,
	 "\ntty write error, position [%d][0x%x], byte [0x%02x]\n",
          pos		,
          pos 		,
        *(buffer + pos)
       );

// 
       delete buffer;			// free allocated buffer
       return(0);			// 
      }

//////////////////////////////////////////////////////////////////////////////
// read writed block /////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

     u_char rbuf[1024];			// read buffer
     int i;     
     for(i = 0; i < wlen; ++i)
      { 
// clear read buffer /////////////////////////////////////////////////////////
       rbuf[i] = 0;
      }
      
//  
     int rtimeout;			// read timeout 
     rtimeout = (wlen * 11) / inspeed + 10;           
      
     if(read_tty(rbuf, wlen, rtimeout) == 0)
      {
       if(kill_link == 1)
        {
         fprintf
          (
            stderr	,
          "\nFlash write terminated."
          );
// 
         exit(1);
        }

// 
       fprintf
        (
	   stderr,
	 "\nTimeout for read writed byte\n"
        );

// 
       delete buffer;			// delete allocated buffer
       return(0);
      }

//////////////////////////////////////////////////////////////////////////////
// compare writed and received block /////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

     for(i = 0; i < wlen; ++i)
      { 
       if(rbuf[i] != buffer[pos+i])
        {
         fprintf
          ( 
            stderr			,
           "\nRead byte [0x%02x] is not equal writed byte [0x%02x],"
           "position [%d][0x%x]\n"	,
            rbuf[i] 			,
            buffer[pos+i]		,
            pos				,
            pos
          );

// 
         delete buffer;			// free allocated buufer
         return(0);
        }
      }

//
     pos += wlen;			// new write position
    }
  } 

// 
 printf("Ok\n");
 return(1);
}


//////////////////////////////////////////////////////////////////////////////
// fast flash write function /////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

int proc_FastWrite(void)
{
//////////////////////////////////////////////////////////////////////////////
// open input file ///////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

// 
 FILE * fi;				// FILE struct  
 fi = fopen(inpfilenam,"r+b"); 		// open input file 	
 if(fi == 0)
  {
// file open error ///////////////////////////////////////////////////////////

   fprintf
    (
        stderr	,
     "\nInput file [%s] open error\n", 
       inpfilenam
    );
// 
   return(0);
  }

//////////////////////////////////////////////////////////////////////////////
// read sizeof input file //////////////////////////////////////////////////// 
//////////////////////////////////////////////////////////////////////////////

 int len;				// length 
 fseek(fi,0,SEEK_END);			// seek to file end
 len = ftell(fi);			// read position 
 if(len <= 0)
  {
   fclose(fi);
   fprintf
    (
       stderr,	
     "\nSize read of input file [%s] error\n", 
      inpfilenam
    );
// 
   return(0);
  }

// 
 if(file_size == 0)
  {
// sizeof writed data is not defined in command line ////////////////////////
   file_size = len;			// = file length 
  }

/////////////////////////////////////////////////////////////////////////////
// allocate buffer //////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

// 
 u_char * buffer;
 buffer = new u_char [len];
 if(buffer == 0)
  {
// buffer alloc error ///////////////////////////////////////////////////////
   fclose(fi);

   fprintf
    (
       stderr	,
     "\nBuffer alloc error [%d][0x%x]\n", 
       len,
       len
    );
// 
   return(0);
  }

// read input file to buffer ////////////////////////////////////////////////
 fseek(fi,0,SEEK_SET);			// to file begin 
 int pos;				// current position in file  	
 pos = 0;				// start position 
 while(feof(fi) == 0)
  {
// read char from file //////////////////////////////////////////////////////

   u_char ch;
   if(fread( &ch, sizeof(ch), 1, fi) < 1)
    {
// read file error //////////////////////////////////////////////////////////
     if(feof(fi))
      {
// eof //////////////////////////////////////////////////////////////////////  
       if(pos >= len)
        {
         break;
        }
      } 

     fprintf
      (
        stderr		,
       "\nFile [%s] read error, position [%d,%x]\n", 
        inpfilenam	,
        pos 		,		
	pos  
      );

// 
     delete buffer;			// free allocated buffer
     fclose(fi);			// close open file 
     return(0);  
    } 

   if(pos < len)
    {
     buffer[pos] = ch;
     pos += 1;
    } 
   else
    {
     fprintf(stderr,"\nInternal file read error [%s]\n", inpfilenam);
     fclose(fi);
     return(0);  
    }
  }
//
 fclose(fi);

/////////////////////////////////////////////////////////////////////////////
// read receive ready prompt ////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

 if(read_id() == 0)
  {
   delete buffer;			// free allocated buffer 
   return(0);
  }

/////////////////////////////////////////////////////////////////////////////
// write command (WR) ///////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

 printf("Fast Write flash ...");
 fflush(stdout);

 struct termios tios_saved;		//    

 if(write_speed != 0)
  {
// 
   printf("\nSet Write Speed %d\n", write_speed);
   fflush(stdout);

// 
   int cnt;
   cnt = speed_toh(write_speed);
   if(cnt == 0)
    {					// not supported 
     delete buffer;			// free allocated buffer 
     return(0);				// speed
    }

// 
   u_char wbuf[32];
   wbuf[0] = 'S';			// set speed
   wbuf[1] = 'P';			// command 

   if(write_tty(wbuf,2,0,0) == 0)
    {
     delete buffer;			// free allocated buffer 
     return(0);
    }

   if(
      write_len
       ( 
        ((((u_short)'S')<<8) | 'P'),	// reply to write cmd 
	 write_speed	,		// speed value
	 1
       ) == 0
    )
    {
     delete buffer;			// free allocated buffer 
     return(0);	
    } 

// set our serial line speed ///////////////////////////////////////////////// 

   struct termios tios;
   if(tcgetattr(ttyfd[0], &tios) < 0) 
    {
     fprintf(stderr,"TTY device attribute read error (tcgetattr): (%d)\n", errno);
     delete buffer;			// free allocated buffer 
     return(0);
    }

   tios_saved = tios;			// save TTY settings 
   cfsetospeed(&tios, cnt);	
   cfsetispeed(&tios, cnt);
   if(tcsetattr(ttyfd[0], TCSAFLUSH, &tios) < 0)
    {
     fprintf(stderr,"TTY device set attribute error (tcsetattr)\n");
     exit(1);
    }        

  }

 if(write_offset != 0)
  {
   printf("Offset 0x%x (%d)\n", write_offset, write_offset);
  }

 if(read_id() == 0)
  {
   delete buffer;			// free allocated buffer 

   if(write_speed != 0)
    {
     if(tcsetattr(ttyfd[0], TCSAFLUSH, &tios_saved) < 0)
      {
       fprintf(stderr,"can't restore TTY settings\n");
       exit(1);
      }        
    }

   return(0);
  }

//
 u_long crc;				// calculated CRC 
 crc = 0xFFFF;

 struct timezone tzone;	
 struct timeval tstart;	
 struct timeval tend;	
 tstart.tv_sec  = 0;			// 1 sec
 tstart.tv_usec = 0;			//  
 tend.tv_sec  = 0;			// 1 sec
 tend.tv_usec = 0;			//  

//
 int rvl;				// return code 
//
 rvl = 1; 

 gettimeofday( & tstart, & tzone);	
// 
 pos = 0;				// start position 
 while(pos < file_size)
  {
   int wlen;				// writed len
   wlen = file_size - pos;		// from current position to end file
   if(wlen > 512)
    {					// 
     wlen = 512;			// set write block size
    } 

//    
   u_char databuf[512];

   int i;
   for(i = 0; i < wlen; ++i)
    {
     databuf[i] = buffer[pos+i];	// copy to data
    }

   while(i < 512)
    {
     databuf[i++] = 0;			// fill end zero
    }

//////////////////////////////////////////////////////////////////////////////
// write command /////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

   u_char wbuf[32];
   wbuf[0] = 'W';			// write block
   wbuf[1] = 'B';			// command 

   if(write_tty(wbuf,2,0,0) == 0)
    {
     rvl = 0;
     break;
    }

//printf("1\n");
// write destination position ////////////////////////////////////////////////

   if(
      write_len
       ( 
        ((((u_short)'W')<<8) | 'B'),	// reply to write cmd 

	 write_offset + 		// write offset 
	 pos				// data position 
       ) == 0
    )
    {
     rvl = 0;	
     break;
    } 

   if(hash != 0)
    {
     if(pos > 0 && (pos % 1024) == 0)
      {
       fprintf(stdout, "#");
       fflush(stdout);       
      }
    } 

// write data buffer /////////////////////////////////////////////////////////

    if(write_tty(databuf, 512, 0, 0) == 0)
     {
// write byte error //////////////////////////////////////////////////////////
      fprintf
       (
	  stderr	,
	 "\ntty write error, position [%d][0x%x], byte [0x%02x]\n",

          pos		,		// position in decimal format 
          pos 		,		// position in hex format 	
        *(buffer + pos)			// writed char 
       );

// 
      rvl = 0;
      break;
     }

//
   crc = 0xFFFF;			// preset CRC     

// 
   u_char crcbuf[32];     		// CRC buffer 
   sprintf
    (
     (char *) crcbuf 	,
     "%08x"		, 
      write_offset +			// write offset to CRC buffer
      pos
     );    	

#define CCITT_POLYNOM	0x1021		// x^16+x12^+x^5+x^0

// calculate offset CRC ////////////////////////////////////////////////////// 

   int crcbyte;
   for(crcbyte = 0; crcbyte < 8; ++crcbyte)
    {
     u_char ch;
     ch = crcbuf[crcbyte];		// read character
// 
     int bit;
     for(bit = 0; bit < 8; ++bit)
      {
       crc <<= 1;
       if(ch & 0x0080) 
        {
         crc ^= CCITT_POLYNOM;
        } 

       ch <<= 1;
      }
    } 

   int dpos;
   for(dpos = 0; dpos < 512; ++dpos)
    {
     u_char ch;
     ch = databuf[dpos];			// read character

// 
     int bit;
     for(bit = 0; bit < 8; ++bit)
      {
       crc <<= 1;
       if(ch & 0x0080) 
        {
         crc ^= CCITT_POLYNOM;
        } 

       ch <<= 1;
      }
    } 

// read CRC //////////////////////////////////////////////////////////////////

   if(
     read_tty
      (
       crcbuf	, 
       8	, 
       10
      ) == 0
    )
    {
     if(kill_link == 1)
      {
       fprintf
        (
          stderr	,
         "\nFlash write terminated."
        );
// 
       exit(1);
      }

     fprintf
      (
       stderr,
      "\nRead CRC Error\n"
      );

//
     rvl = 0;
     break;
    }

// convert received CRC from ASCII to digital format /////////////////////////  

   u_long readcrc;
   readcrc = 0;

   int rpos;
   for(rpos = 0; rpos < 8; ++rpos)
    {
     readcrc <<= 4; 

//
     u_char ch;
     ch = crcbuf[rpos];
     if(ch >= '0' && ch <= '9')
      {
       readcrc |= (ch - '0'); 
      }
     else
     if(ch >= 'a' && ch <= 'f')
      {
       readcrc |= (ch - 'a') + 10; 
      }
     else
     if(ch >= 'A' && ch <= 'F')
      {
       readcrc |= (ch - 'A') + 10; 
      }
     else
      {
       fprintf
        (
         stderr,
	"\nError in received CRC [%c%c%c%c%c%c%c%c]\n",

         crcbuf[0],     
         crcbuf[1],     
         crcbuf[2],     
         crcbuf[3],     
         crcbuf[4],     
         crcbuf[5],     
         crcbuf[6],     
         crcbuf[7]
	);      
//
       rvl = 0;
       break;
      }  
    }     

   if(rvl == 0)
    {  
     break;
    } 

//
   if(crc != readcrc)
    {
     fprintf
      (
       stderr,
      "\nReceived CRC [0x%08x] is not equal calculated [0x%08x]\n",
       (unsigned int) readcrc,
       (unsigned int) crc
      ); 
//
     rvl = 0;
     break;
    } 

//
   pos += wlen;				// to write next block	
  }


 if(rvl == 1)
  {
// 
   gettimeofday( & tend, & tzone);	
   u_long dsec;
   u_long dus;
    
   dsec = tend.tv_sec - tstart.tv_sec;
   if(tend.tv_usec >= tstart.tv_usec)
    {
      dus = tend.tv_usec - tstart.tv_usec;
    }
   else
    {
     dsec -= 1;
     dus = tend.tv_usec + 1000000 - tstart.tv_usec;
    }

// 
   double fsec;
   fsec = (double) dsec + (double) dus / 1000. / 1000.;
   fprintf
    (
        stdout,
     "\nTransfer time = %d.%03d sec",
        (int) dsec		,
       (int) dus / 1000
    ); 
 
   if(fsec != 0)
    { 
     double speed;
     speed = file_size / fsec;

     fprintf
     (
           stdout,
       "\nSpeed = %.1f bytes/sec",
          speed
      ); 
    }
  }
  
 if(write_speed != 0)
  {
   printf("\nRestote Speed %d\n", inspeed);
   fflush(stdout);

   u_char wbuf[32];
   wbuf[0] = 'S';			// set speed
   wbuf[1] = 'P';			// command 

   if(write_tty(wbuf,2,0,0) == 0)
    {
     return(0);
    }

   if(
      write_len
       ( 
        ((((u_short)'S')<<8) | 'P'),	// reply to write cmd 
	 inspeed		   ,	// speed value
	 1				// ignore reply value
       ) == 0
    )
    {
     return(0);	
    } 

   sleep(1);

   if(tcsetattr(ttyfd[0], TCSAFLUSH, &tios_saved) < 0)
    {
     fprintf(stderr,"can't restore TTY settings\n");
     return(0);
    }        
  }

// 
 fprintf(stdout,"\n");
//
 return(1);
}

//////////////////////////////////////////////////////////////////////////////
// read flash ////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

int proc_Read(void)
{
 if(file_size <= 0)
  {
   fprintf
    (
      stderr,
     "\nRead data size is not defined\n"
    );
// 
   return(0);
  }

// read receive ready prompt ("rr") //////////////////////////////////////////

 if(read_id() == 0)
  {
   return(0);
  }

// open output file //////////////////////////////////////////////////////////

 printf("Read flash ...");
 fflush(stdout);

 FILE * fo;
 fo = fopen(outfilenam,"w+b"); 	
 if(fo == 0)
  {
   printf("\nOutput file [%s] open error\n", inpfilenam);
   return(0);
  }

// write command /////////////////////////////////////////////////////////////

 u_char wbuf[32];
 wbuf[0] = 'R';
 wbuf[1] = 'D';
 if(write_tty(wbuf,2,3,0) == 0)
  {
   return(0);
  }

// write length //////////////////////////////////////////////////////////////

 if
  (
   write_len
    (
     (((u_short)'R')<<8) | 'D'	,	// reply to read command 
        file_size			// data size
    ) == 0
  )
  {
   return(0);
  } 


 int pos;
 pos = 0;
 for(pos = 0; pos < file_size; ++pos)
  {
   if(hash != 0)
    {
     if(pos > 0 && (pos % 1024) == 0)
      {
       fprintf(stdout, "#");
       fflush(stdout);       
      }
    } 

   u_char rbuf[32];
   rbuf[0] = 0;
   if(read_tty(rbuf, 1, 10) == 0)
    {
// 
     if(kill_link == 1)
      {
       fprintf
        (
          stderr	,
         "\nFlash read terminated."
        );

// 
       fclose(fo);
       exit(1);
      }

// 
     fprintf
      (
          stderr	,
       "\nRead byte timeout, offset [%d][0x%x]\n"	,
          pos 		,
          pos
      );
//
     fclose(fo);
     return(0);
    }



// write read byte to file ///////////////////////////////////////////////////
   fwrite(rbuf,1,1,fo);
  }

//
 printf("Ok\n");
 fclose(fo);
 return(1);
}

/////////////////////////////////////////////////////////////////////////////
// print content SYSCFG /////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////


int PrintSYSCFG(char * nam, u_int val)
{
 if(nam == 0)
  {
   return(0);
  } 

//
 printf("\n%12s %08x", nam, val);
 printf("\n%12s ", "");
 int i;
 for(i = 31; i >= 0; --i)
  {
   if( ((val >> i) & 0x01) != 0)
    {
     printf("1");
    }
   else
    {
     printf("0");
    }
  }

 printf("\n%12s 10987654321098765432109876543210", "");
 printf("\n%12s  3         2         1          ", "");

// 
 printf("\n[0]    Stal enable (SE).Must be zero...[%d]", (val&1));
 printf("\n[1]    Cache enable (CE)...............[%d]",((val>>1) & 1));
 printf("\n[2]    Write buffer enable (WE)........[%d]",((val>>2) & 1));
 printf("\n[5:4]  Cache mode (CM).................[%d]",((val>>4) & 3));

 switch( ((val >> 4) & 3) )
  {
   case 0 : printf("\n        00 = 4-Kbyte SRAM, 4-Kbyte cache");  break;
   case 1 : printf("\n        01 = 0-Kbyte SRAM, 8-Kbyte cache");  break;
   case 2 : printf("\n        10 = 8-Kbyte SRAM, 0-Kbyte cache");  break;
   case 3 : printf("\n        11 = Not Allowed"); break;
   default: printf("\n        Internal Error"); break; 
  }

// 
 printf("\n[15:6] Internal SRAM base pointer..,...[%x]", (val>> 6)&0x3FF); 
 printf("\n       ................................[%x]",((val>> 6)&0x3FF)<<16); 

 printf("\n[25:16]Special register bank base ptr..[%x]", (val>>16)&0x3FF); 
 printf("\n       ................................[%x]",((val>>16)&0x3FF)<<16); 
 printf("\n[29:26]Product Identifier (PD_ID)......[%x]", (val>>26)&0xF);
 printf("\n[31]   Sync. DRAM mode.................[%x]", (val>>31)&1);
 return(1);
}

/////////////////////////////////////////////////////////////////////////////
// print content EXTDBWTH ///////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

int PrintEXTDBWTH(char * nam, u_int val)
{
 if(nam == 0)
  {
   return(0);
  } 

// print register name & value //////////////////////////////////////////////

 printf("\n%12s %08x", nam, val);
 printf("\n%12s ", "");
 int i;
 for(i = 31; i >= 0; --i)
  {
   if( ((val >> i) & 0x01) != 0)
    {
     printf("1");
    }
   else
    {
     printf("0");
    }
  }
 printf("\n%12s 10987654321098765432109876543210", "");
 printf("\n%12s  3         2         1          ", "");

//
 printf("\nData bus width for:"); 
 printf("\n[ 1: 0] ROM/SRAM/FLASH bank0 (DSR0) ...[%x]", (val >> 0) & 3);
 printf("\n[ 3: 2] ROM/SRAM/FLASH bank 1 (DSR1)...[%x]", (val >> 2) & 3);
 printf("\n[ 5: 4] ROM/SRAM/FLASH bank 2 (DSR2)...[%x]", (val >> 4) & 3);
 printf("\n[ 7: 6] ROM/SRAM/FLASH bank 3 (DSR3)...[%x]", (val >> 6) & 3);
 printf("\n[ 9: 8] ROM/SRAM/FLASH bank 4 (DSR4)...[%x]", (val >> 8) & 3);
 printf("\n[10:11] ROM/SRAM/FLASH bank 5 (DSR5)...[%x]", (val >>10) & 3);
 printf("\n[13:12] DRAM bank 0 (DSD0).............[%x]", (val >>12) & 3);
 printf("\n[15:14] DRAM bank 1 (DSD1).............[%x]", (val >>14) & 3);
 printf("\n[17:16] DRAM bank 2 (DSD2).............[%x]", (val >>16) & 3);
 printf("\n[19:18] DRAM bank 3 (DSD3).............[%x]", (val >>18) & 3);
 printf("\n[21:20] external I/O bank 0 (DSX0).....[%x]", (val >>20) & 3);
 printf("\n[23:22] external I/O bank 1 (DSX1).....[%x]", (val >>22) & 3);
 printf("\n[25:24] external I/O bank 2 (DSX2).....[%x]", (val >>24) & 3);
 printf("\n[27:26] external I/O bank 3 (DSX3).....[%x]", (val >>26) & 3);

//
 return(1);
}

/////////////////////////////////////////////////////////////////////////////
// print ROMCON /////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

int PrintROMCON(char * nam, u_int val)
{
 if(nam == 0)
  {
   return(0);
  } 
//
 printf("\n%12s %08x", nam, val);
 printf("\n%12s ", "");
 int i;
 for(i = 31; i >= 0; --i)
  {
   if( ((val >> i) & 0x01) != 0)
    {
     printf("1");
    }
   else
    {
     printf("0");
    }
  }
 printf("\n%12s 10987654321098765432109876543210", "");
 printf("\n%12s  3         2         1          ", "");

 printf("\n[1:0]   Page mode configuration (PMC)..[%x]", (val >> 0) & 3);
 switch((val >> 0) & 3)
  {
   case  0 : printf("\n         00 = Normal ROM"); break;
   case  1 : printf("\n         01 = 4-word page"); break;
   case  2 : printf("\n         10 = 8-word page"); break;
   case  3 : printf("\n         11 = 16-word page"); break;
   default : printf("\n         Internal error"); break;
  }

 printf("\n[3:2]   Page address access time (tPA).[%x]", (val >> 2) & 3);
 switch((val >> 2) & 3)
  {
   case  0 : printf("\n          00 = 5 cycles"); break;
   case  1 : printf("\n          01 = 2 cycles"); break;
   case  2 : printf("\n          10 = 3 cycles"); break;
   case  3 : printf("\n          11 = 4 cycles"); break;
   default : printf("\n          Internal error"); break; 
  }

// 
 printf("\n[6:4]   Programmable access cycle(tACC)[%x]", (val >> 4) & 7);
 switch((val >> 4) & 7)
  {
   case  0 : printf("\n          000 = Disable bank");  break;
   case  1 : printf("\n          001 = 2 cycles"); break;
   case  2 : printf("\n          010 = 3 cycles"); break;
   case  3 : printf("\n          011 = 4 cycles"); break;
   case  4 : printf("\n          100 = 5 cycles"); break;
   case  5 : printf("\n          101 = 6 cycles"); break;
   case  6 : printf("\n          110 = 7 cycles"); break;
   case  7 : printf("\n          111 = Reserved"); break;
   default : printf("\n          Internal error"); break;
  }

// 
 printf("\n[19:10]  ROM/SRAM/Flash base pointer...[%x]",  (val>>10)&0x3FF);
 printf("\n         ..............................[%x]", ((val>>10)&0x3FF)<<16);

 printf("\n[29:20]  ROM/SRAM/FLASH next pointer...[%x]",  (val>>20)&0x3FF);
 printf("\n         ..............................[%x]", ((val>>20)&0x3FF)<<16);

//
 return(1);
}

/////////////////////////////////////////////////////////////////////////////
// print content DRAMCON ////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

int PrintDRAMCON(char * nam, u_int val)
{
 if(nam == 0)
  {
   return(0);
  } 

//
 printf("\n%12s %08x", nam, val);
 printf("\n%12s ", "");
 int i;
 for(i = 31; i >= 0; --i)
  {
   if( ((val >> i) & 0x01) != 0)
    {
     printf("1");
    }
   else
    {
     printf("0");
    }
  }
 printf("\n%12s 10987654321098765432109876543210", "");
 printf("\n%12s  3         2         1          ", "");

// 
 printf("\n [0]      EDO mode(EDO) (note).........[%x]", (val >> 0) & 1);
 switch((val >> 0) & 1)
  {
   case 0 : printf("\n        0 = Normal DRAM (Fast page mode DRAM)"); break;
   case 1 : printf("\n        1 = EDO DRAM"); break;
   default: printf("\n        Internal error"); break;
  }

//   
 printf("\n [2:1]    CAS strobe time (tCS)........[%x]", (val >> 1) & 3);
 switch((val >> 1) & 3) 
  {
   case 0 : printf("\n          00 = 1 cycle"); break;
   case 1 : printf("\n          01 = 2 cycles"); break;
   case 2 : printf("\n          10 = 3 cycles"); break;
   case 3 : printf("\n          11 = 4 cycles"); break;
   default: printf("\n          Internal error"); break;
  }

// 
 printf("\n [3:3]    CAS pre-charge time (tCP )...[%x]", (val >> 3) & 1);
 switch((val >> 3) & 1)
  {
   case 0 : printf("\n          0 = 1 cycle"); break;
   case 1 : printf("\n          1 = 2 cycles"); break;
   default: printf("\n          Internal error"); break;
  }

// 
 printf("\n NOTE     In SDRAM mode, this bit affect SDRAM cycle.");
 printf("\n          tCS value [1] : 0 = 1 cycle, 1 = 2 cycle");

// 
 printf("\n [6:4]    Reserved ....................[%x]", (val >> 4) & 7);
 printf("\n          These bits default value is 000. But, you must set to 001.");

// 
 printf("\n [7]      RAS to CAS delay(tRC or tRCD)[%x]", (val >> 7) & 1);
 switch((val >> 7) & 1)
  {
   case 0 : printf("\n           0 = 1 cycle"); break;
   case 1 : printf("\n           1 = 2 cycles"); break;
   default: printf("\n           Internal error"); break;
  }

// 
 printf("\n [9:8]    RAS pre-charge time (tRP) ...[%x]", (val >> 8) & 3);
 switch( ((val >> 8) & 3) )
  {
   case 0 : printf("\n           00 = 1 cycle"); break;
   case 1 : printf("\n           01 = 2 cycles"); break;
   case 2 : printf("\n           10 = 3 cycles"); break;
   case 3 : printf("\n           11 = 4 cycles"); break;
  }
  
//
 printf("\n [19:10]  DRAM bank # base pointer ....[%x]",  (val>>10)&0x3FF);
 printf("\n          .............................[%x]", ((val>>10)&0x3FF)<<16);

//
 printf("\n [29:20]  DRAM bank # Next pointer ....[%x]",  (val>>20)&0x3FF);
 printf("\n          .............................[%x]", ((val>>20)&0x3FF)<<16);

// 
 printf("\n [31:30]  Number of column bits (CAN)..[%x]", (val >> 30) & 3);
 switch((val >> 30) & 3)
  {
   case 0 : printf("\n           00 = 8 bits"); break;
   case 1 : printf("\n           01 = 9 bits"); break;
   case 2 : printf("\n           10 = 10 bits"); break;
   case 3 : printf("\n           11 = 11 bits"); break;
   default: printf("\n           Internal error"); break;
  }

//
 return(1);
}


/////////////////////////////////////////////////////////////////////////////
// Print REFEXTCON register /////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

int PrintREFEXTCON(char * nam, u_int val)
{
 if(nam == 0)
  {
   return(0);
  } 
//
 printf("\n%12s %08x", nam, val);
 printf("\n%12s ", "");
 int i;
 for(i = 31; i >= 0; --i)
  {
   if( ((val >> i) & 0x01) != 0)
    {
     printf("1");
    }
   else
    {
     printf("0");
    }
  }
 printf("\n%12s 10987654321098765432109876543210", "");
 printf("\n%12s  3         2         1          ", "");

// 
 printf("\n[9:0]     External I/O base address ...[%x]", ((val>>0) & 0x3FF));
 printf("\n          .............................[%x]", ((val>>0) & 0x3FF)<<16);
 printf("\n[15]      Validity of special reg(VSF).[%x]", ((val >> 15) & 1));
 switch((val >> 15) & 1)
  {
   case 0 : printf("\n            0 = Not accessible to memory bank"); break;
   case 1 : printf("\n            1 = Accessible to memory bank"); break;
   default: printf("\n            internal error"); break;
  }

//   
 printf("\n[16]      Refresh enable (REN) ........[%x]", ((val >> 16) & 1));
 switch((val >> 16) & 1)
  {
   case 0 : printf("\n            0 = Disable DRAM refresh"); break;
   case 1 : printf("\n            1 = Enable DRAM refresh"); break;
   default: printf("\n            internal error"); break;
  }

//   
 printf("\n[19:17]   CAS hold time(tCHR)..........[%x]", ((val >> 17) & 7));
 switch((val >> 17) & 7)
  {
   case 0 : printf("\n            000 = 1 cycle"); break;
   case 1 : printf("\n            001 = 2 cycles"); break;
   case 2 : printf("\n            010 = 3 cycles"); break;
   case 3 : printf("\n            011 = 4 cycles"); break;
   case 4 : printf("\n            100 = 5 cycles"); break;
   case 5 : printf("\n            101 = Not used (6 cycles)"); break;
   case 6 : printf("\n            110 = Not used"); break;
   case 7 : printf("\n            111 = Not used"); break;
   default: printf("\n            internal error"); break;
  }

// 
 printf("\n NOTE :    In EDO/normal DRAM mode, CAS hold time can be programmed upto");
 printf("\n           5 cycles. But in SDRAM mode, this bit fields function are");
 printf("\n           defined as ROW Cycle Time (tRC) and can be programmed upto");
 printf("\n           6 cycles.");

// 
 printf("\n[20]      CAS setup time(t CSR)........[%x]", ((val >> 20) & 1));
 switch((val >> 20) & 1)
  {
   case 0 : printf("\n            0 = 1 cycle"); break;
   case 1 : printf("\n            1 = 2 cycles"); break;
   default: printf("\n            internal error"); break;
  }
 printf("\nNOTE :    In SDRAM mode, this bit field is reserved.");

//
 printf("\n[31:21]   Refresh count value (duration) ...[%x]", ((val >> 21)));
 printf("\n          The refresh period is calculated as (2 ** 11 - Value + 1) / fMCLK"); 

//
 double prd = (double) (2048  - (val >> 21) + 1) / 50000000.;  
 printf("\n          [%f]", prd); 
 return(1);
}

//////////////////////////////////////////////////////////////////////////////
// read registers cmd ////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

int registerval(const char * str, u_long & reg)
{
// 
 if(str == 0) 
  {
   return(0);
  } 

// 
 while((*str) == ' ')
  {
   str++;
  }

// 
 u_long val;
 int rvl;
// 
 rvl = 1; 
 val = 0; 

// 
 int i;
 for(i = 0; i < 8; ++i)
  {
   val <<= 4;
   if( *str >= '0' && *str <= '9')
    {
     val |= (*str - '0');
    }    
   else
   if( *str >= 'a' && *str <= 'f')
    {
     val |= (*str - 'a') + 10;
    }
   else
   if( *str >= 'A' && *str <= 'F')
    {
     val |= (*str - 'A') + 10;
    }
   else
    {
     rvl = 0;
    }
//
   ++str;
  }

 if(rvl == 1)
  {
   reg = val;
  }

 return(rvl);
}



int proc_ReadRegisters(void)
{
 printf("Read Registers ...\n");

// read receive ready prompt ("rr") //////////////////////////////////////////

 if(read_id() == 0)
  {
   return(0);
  }

// write command /////////////////////////////////////////////////////////////

 u_char wbuf[32];
 wbuf[0] = 'R';
 wbuf[1] = 'R';
 if(write_tty(wbuf,2,3,0) == 0)
  {
   return(0);
  }

// read command reply ////////////////////////////////////////////////////////

#define READ_REGISTERS_RESPONCE (u_short)(((u_short)'R' << 8) | 'R')

 u_short code = 0;
 int cnt = 10;
 while(cnt-- > 0)
  {
   u_char rbuf[32];
   rbuf[0] = 0;
   if(read_tty(rbuf, 1, 5) == 0)
    {
     if(kill_link == 1)
      {
       fprintf
        (
            stderr	,
         "\nRead registers terminated\n"
        );
//
       exit(1);
      }

// 
     fprintf
      (
          stderr	,
       "\nRead byte timeout\n"
      );
//
     return(0);
    }
  
  
   code = (code << 8) | rbuf[0]; 
   if(code == READ_REGISTERS_RESPONCE)
    {
     break;
    }
  }

 if(code != READ_REGISTERS_RESPONCE)
  {
   fprintf
    (
     stderr	,
     "Read Registers Timeout"
    );
  }

// registers values //////////////////////////////////////////////////////////

 u_long SYSCFG    = 0;			// system configuration register 	
 u_long EXTDBWTH  = 0;
 u_long ROMCON0   = 0;
 u_long ROMCON1   = 0;
 u_long ROMCON2   = 0;
 u_long ROMCON3   = 0;
 u_long ROMCON4   = 0;
 u_long ROMCON5   = 0;
 u_long DRAMCON0  = 0;
 u_long DRAMCON1  = 0;
 u_long DRAMCON2  = 0;
 u_long DRAMCON3  = 0;
 u_long REFEXTCON = 0;

#define SYSCFG_READ    0x0001		// 
#define EXTDBWTH_READ  0x0002		// 
#define ROMCON0_READ   0x0004		// 
#define ROMCON1_READ   0x0008		// 
#define ROMCON2_READ   0x0010		// 
#define ROMCON3_READ   0x0020		// 
#define ROMCON4_READ   0x0040		// 
#define ROMCON5_READ   0x0080		// 
#define DRAMCON0_READ  0x0100		// 
#define DRAMCON1_READ  0x0200		// 
#define DRAMCON2_READ  0x0400 		// 
#define DRAMCON3_READ  0x0800		// 
#define REFEXTCON_READ 0x1000		// 
    
#define READALL_READ   0x1FFF

// 
 int more;
 more = READALL_READ;

// 
 char r_buf[1024];			// read buffer 
 int pos = 0;				// position in read buffer  
 while(more)
  {
   if(pos + 1 >= 1024)
    {
     fprintf
      (
          stderr	,
       "\nRead buffer overflow\n"
      );
//
     return(0);
    }

// 
   if(read_tty( (u_char *)(r_buf + pos), 1, 3) == 0)
    {
     if(kill_link == 1)
      {
       fprintf
        (
            stderr	,
         "\nRead registers terminated\n"
        );
//
       exit(1);
      }

     fprintf
      (
          stderr	,
       "\nRead byte timeout\n"
      );
//
     break;
    }

// 
   pos += 1; 	
   r_buf[pos] = '\0';

// 
   const char * str;      

// 
   str = strstr(r_buf,"SYSCFG");
   if(str != NULL)
    {
// read SYSCFG value /////////////////////////////////////////////////////////
     str += strlen("SYSCFG");
     if(registerval(str,SYSCFG) != 0)
      {
// SYSCFG readed /////////////////////////////////////////////////////////////
       more &= ~SYSCFG_READ;
      }
    }

// EXTBDWTH (External Data Bus Width) ////////////////////////////////////////

   str = strstr(r_buf,"EXTDBWTH");
   if(str != NULL)
    {
     str += strlen("EXTDBWTH");
     if(registerval(str, EXTDBWTH) != 0)
      {
       more &= ~EXTDBWTH_READ;		// EXTDBWTH is readed
      }
    }

// ROMCON0 // Rom/Flash/SRAM bank 0 configuration register ///////////////////
    
   str = strstr(r_buf,"ROMCON0");
   if(str != NULL)
    {
     str += strlen("ROMCON0");
     if(registerval(str, ROMCON0) != 0)
      {
       more &= ~ROMCON0_READ;		// ROMCON0 is readed 
      }
    }

// ROMCON1 // ROM/Flash/SRAM bank 1 configuration register ///////////////////

   str = strstr(r_buf,"ROMCON1");
   if(str != NULL)
    {
     str += strlen("ROMCON1");
     if(registerval(str, ROMCON1) != 0)
      {
       more &= ~ROMCON1_READ;		// ROMCON1 is readed 
      }
    } 

// ROMCON2 // ROM/Flash/SRAM bank 2 configuration register ///////////////////

   str = strstr(r_buf,"ROMCON2");
   if(str != NULL)
    {
     str += strlen("ROMCON2");
     if(registerval(str, ROMCON2) != 0)
      {
       more &= ~ROMCON2_READ;		// ROMCON2 is readed 
      }
    }

// ROMCON3 // ROM/Flash/SRAM bank 3 configuration register ///////////////////

   str = strstr(r_buf,"ROMCON3");
   if(str != NULL)
    { 
     str += strlen("ROMCON3");
     if(registerval(str, ROMCON3) != 0)
      {
       more &= ~ROMCON3_READ;
      }
    }

// ROMCON4 ///////////////////////////////////////////////////////////////////

   str = strstr(r_buf,"ROMCON4");
   if(str != NULL)
    {
     str += strlen("ROMCON4");
     if(registerval(str, ROMCON4) != 0)
      {
       more &= ~ROMCON4_READ;
      }
    }

// ROMCON5 ///////////////////////////////////////////////////////////////////

   str = strstr(r_buf,"ROMCON5");
   if(str != NULL)
    {
     str += strlen("ROMCON5");
     if(registerval(str, ROMCON5) != 0)
      {
       more &= ~ROMCON5_READ;
      }
    }

// DRAMCON0 //////////////////////////////////////////////////////////////////

   str = strstr(r_buf,"DRAMCON0");
   if(str != NULL)
    {
     str += strlen("DRAMCON0");
     if(registerval(str, DRAMCON0) != 0)
      {
       more &= ~DRAMCON0_READ;
      }
    }

// DRAMCON1 //////////////////////////////////////////////////////////////////

   str = strstr(r_buf,"DRAMCON1");
   if(str != NULL)
    {
     str += strlen("DRAMCON1");
     if(registerval(str, DRAMCON1) != 0)
      {
       more &= ~DRAMCON1_READ;
      }
    }

// DRAMCON2 ////////////////////////////////////////////////////////////////// 

   str = strstr(r_buf,"DRAMCON2");
   if(str != NULL)
    {
     str += strlen("DRAMCON2");
     if(registerval(str, DRAMCON2) != 0)
      {
       more &= ~DRAMCON2_READ;
      }
    }

// DRAMCON3 //////////////////////////////////////////////////////////////////

   str = strstr(r_buf,"DRAMCON3");
   if(str != NULL)
    {
     str += strlen("DRAMCON3");
     if(registerval(str, DRAMCON3) != 0)
      {
       more &= ~DRAMCON3_READ;
      }
    } 

// REFEXTCON /////////////////////////////////////////////////////////////////

   str = strstr(r_buf,"REFEXTCON");
   if(str != NULL)
    {
     str += strlen("REFEXTCON");
     if(registerval(str, REFEXTCON) != 0)
      {
       more &= ~REFEXTCON_READ;
      }
    }
  } 

//////////////////////////////////////////////////////////////////////////////

 int i;
 for(i = 0; i < pos; ++i)
  {
   printf("%c", r_buf[i]);
  }
 printf("\n");
 fflush(stdout);

//////////////////////////////////////////////////////////////////////////////

 if((more & SYSCFG_READ) == 0)    
  {
   PrintSYSCFG("SYSCFG",SYSCFG);
  }
 else
  {
   printf("\nSYSCFG register is not readed."); 
  }

//////////////////////////////////////////////////////////////////////////////

 if((more & EXTDBWTH_READ) == 0)  
  {
   PrintEXTDBWTH("EXTDBWTH",EXTDBWTH);
  }
 else
  {
   printf("\nEXTDBWTH register is not readed."); 
  }

//////////////////////////////////////////////////////////////////////////////

 if((more & ROMCON0_READ) == 0)   
  {
   PrintROMCON("ROMCON0",ROMCON0);
  }
 else
  {
   printf("\nROMCON0 register is not readed."); 
  }

//////////////////////////////////////////////////////////////////////////////

 if((more & ROMCON1_READ) == 0)   
  {
   PrintROMCON("ROMCON1",ROMCON1);
  }
 else
  {
   printf("\nROMCON1 register is not readed."); 
  }

//////////////////////////////////////////////////////////////////////////////

 if((more & ROMCON2_READ) == 0)   
  {
   PrintROMCON("ROMCON2",ROMCON2);
  }
 else
  {
   printf("\nROMCON2 register is not readed."); 
  }

//////////////////////////////////////////////////////////////////////////////

 if((more & ROMCON3_READ) == 0)   
  {
   PrintROMCON("ROMCON3",ROMCON3);
  }
 else
  {
   printf("\nROMCON3 register is not readed."); 
  }

//////////////////////////////////////////////////////////////////////////////

 if((more & ROMCON4_READ) == 0)   
  {
   PrintROMCON("ROMCON4",ROMCON4);
  }
 else
  {
   printf("\nROMCON4 register is not readed."); 
  }

//////////////////////////////////////////////////////////////////////////////

 if((more & ROMCON5_READ) == 0)   
  {
   PrintROMCON("ROMCON5",ROMCON5);
  }
 else
  {
   printf("\nROMCON5 register is not readed."); 
  }

//////////////////////////////////////////////////////////////////////////////

 if((more & DRAMCON0_READ) == 0)  
  {
   PrintDRAMCON("DRAMCON0",DRAMCON0);
  }
 else
  {
   printf("\nDRAMCON0 register is not readed."); 
  }

//////////////////////////////////////////////////////////////////////////////

 if((more & DRAMCON1_READ) == 0)  
  {
   PrintDRAMCON("DRAMCON1",DRAMCON1);
  }
 else
  {
   printf("\nDRAMCON1 register is not readed."); 
  }

//////////////////////////////////////////////////////////////////////////////

 if((more & DRAMCON2_READ) == 0)  
  {
   PrintDRAMCON("DRAMCON2",DRAMCON2);
  }
 else
  {
   printf("\nDRAMCON2 register is not readed."); 
  }

//////////////////////////////////////////////////////////////////////////////

 if((more & DRAMCON3_READ) == 0)  
  {
   PrintDRAMCON("DRAMCON3",DRAMCON3);
  }
 else
  {
   printf("\nDRAMCON3 register is not readed."); 
  }

//////////////////////////////////////////////////////////////////////////////

 if((more & REFEXTCON_READ) == 0) 
  {
   PrintREFEXTCON("REFEXTCON",REFEXTCON);
  }
 else
  {
   printf("\nREFEXTCON register is not readed."); 
  }

//////////////////////////////////////////////////////////////////////////////
 return(1);
}


int proc_DramTest(int bytes)
{
 printf("Dram Test ...\n");

// read manufactory code & device ID ////////////////////////////////////////

 if(read_id() == 0)
  {
   return(0);
  }

// write command /////////////////////////////////////////////////////////////

 u_char wbuf[32];

 wbuf[0] = 'D';
 if(bytes == 0)
  {
   wbuf[1] = 'T';			// Dram Test 
  }
 else
 if(bytes == 1)
  {
   wbuf[1] = 'B';			// Dram Byte test	
  }
 else
 if(bytes == 2)
  {
   wbuf[1] = 'H';			// Dram Half word test 
  }
 else
 if(bytes == 4)
  {
   wbuf[1] = 'W';			// Dram Word test
  }
 else
  {
   fprintf(stderr,"\nInternal Error\n");
   return(0);
  }
 
  
 if(write_tty(wbuf,2,3,0) == 0)
  {
   return(0);
  }

//
 struct timezone tzone;	
 struct timeval tstart;	
 struct timeval tend;	
 tstart.tv_sec  = 0;			// 1 sec
 tstart.tv_usec = 0;			//  
 tend.tv_sec  = 0;			// 1 sec
 tend.tv_usec = 0;			//  

 u_long code;
 code = 0;

#define DRAMTEST_WAIT (('W' << 24) | ('a' << 16) | ('i' << 8) | ('t' << 0))

 while(1)
  {
   u_char rbuf[32];
   rbuf[0] = 0;
   if(read_tty(rbuf, 1, 30) == 0)
    {
     if(kill_link == 1)
      {
       fprintf
        (
            stderr	,
         "\nDRAM test terminated.\n"
        );
//
       exit(1);
      }

     continue;
    }

   if(code == DRAMTEST_WAIT)
    { 
     gettimeofday( & tend, & tzone);	

     u_long dsec;
     u_long dus;
    
     dsec = tend.tv_sec - tstart.tv_sec;
     if(tend.tv_usec >= tstart.tv_usec)
      {
       dus = tend.tv_usec - tstart.tv_usec;
      }
     else
      {
       dsec -= 1;
       dus = tend.tv_usec + 1000000 - tstart.tv_usec;
      }

     printf("(%ld sec %ld us)", dsec, dus);
     fflush(stdout);
    }


// write read byte to file ///////////////////////////////////////////////////
   fprintf(stdout,"%c",rbuf[0]);
   fflush(stdout);

// 
   code <<= 8;
   code |= rbuf[0];
   if
    (
     (code & 0xFFFF) == (('O' << 8) | 'k') ||
     (code & 0xFFFF) == (('O' << 8) | 'K')
    )
    {
     printf("\nOK\n");
     break;
    }


  if(code == DRAMTEST_WAIT)
   {
    gettimeofday( & tstart, & tzone);	
   }
  }
// 
 return(1);
}

/////////////////////////////////////////////////////////////////////////////
// read flash manufactory code //////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

int proc_Manufactory(void)
{
// read manufactory code & device ID ////////////////////////////////////////

 if(read_id() == 0)
  {
   return(0);
  }

// 
 printf("Read Manufactory Code...\n");

// write command /////////////////////////////////////////////////////////////

 u_char wbuf[32];
 wbuf[0] = 'M';				// read manufactory code
 wbuf[1] = 'C';				// command 
 if(write_tty(wbuf,2,3,0) == 0)
  {
   return(0);
  }

// read manufactory code reply ///////////////////////////////////////////////
 u_short code;
 code = 0;
 int cnt = 10;

 while(cnt-- >= 0)
  {
   u_char rbuf[32];
   rbuf[0] = 0;
   if(read_tty(rbuf, 1, 3) == 0)
    {
     if(kill_link == 1)
      {
       fprintf
        (
          stderr	,
         "\nRead manufactory code terminated.\n"
        );
// 
       exit(1);
      } 

     fprintf
      (
          stderr	,
       "\nRead byte timeout\n"
      );
//

     break;
    }

   code <<= 8;
   code |= rbuf[0];

#define CMD_MANUF     ((u_short)(( ((u_short)'M') << 8) | ('C'))) // Read Manufactory Code 

//printf("%c\n",rbuf[0]);
//printf("%08x %08x\n",code,CMD_MANUF);

   if(code == CMD_MANUF)
    {
     break;
    }
  }

 if(code != CMD_MANUF)
  {
   fprintf
    (
     stderr	,
   "\nRead Manufactory Code Timeout\n"
    );
 
   return(0);
  } 

// read manufactory code value ///////////////////////////////////////////////
 u_char mbuf[32];
 mbuf[0] = 0;
 mbuf[1] = 0;
 if(read_tty(mbuf, 8, 10) == 0)
  {
   if(kill_link == 1)
    {
     fprintf
      (
          stderr	,
       "\nRead manufactory code terminaded.\n"
      );
//
     exit(1);
    } 

// 
   fprintf
    (
     stderr	,
   "\nRead Manufactory Code Timeout\n"
    );
 
   return(0);
  }

// half byte off manufactory code ////////////////////////////////////////////

 code = 0;
 int i;
 for(i = 0; i < 8; ++i)
  {
   code <<= 4;
   if(mbuf[i] >= '0' && mbuf[i] <= '9')
    {
     code |= (mbuf[i] - '0');
    }
   else
   if(mbuf[i] >= 'a' && mbuf[i] <= 'f')
    {
     code |= ((mbuf[i] - 'a') + 10);
    }
   else
   if(mbuf[i] >= 'A' && mbuf[i] <= 'F')
    {
     code |= ((mbuf[i] - 'A') + 10);
    }
   else
    {
     fprintf
      (
       stderr	,
     "\nError Manufactory Code [%c%c%c%c%c%c%c%c]\n",
       mbuf[0]	,
       mbuf[1]	,
       mbuf[2]	,
       mbuf[3]	,
       mbuf[4]  ,
       mbuf[5]  ,
       mbuf[6]  ,
       mbuf[7]  
      );
     return(0);
   }
  }

// 
 printf("\n Manufactory code = [0x%08x]\n", code);
 return(1);
}

//////////////////////////////////////////////////////////////////////////////
// read flash device id //////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

int proc_Deviceid(void)
{
// read manufactory code & device ID ////////////////////////////////////////

 if(read_id() == 0)
  {
   return(0);
  }

// 
 printf("Read Flash Device Id...\n");

// write command /////////////////////////////////////////////////////////////

 u_char wbuf[32];
 wbuf[0] = 'I';				// read id 
 wbuf[1] = 'D';				// command 
 if(write_tty(wbuf,2,3,0) == 0)
  {
   return(0);
  }

// read command reply ////////////////////////////////////////////////////////
 u_short code;
 code = 0;
 int cnt = 10;

 while(cnt-- >= 0 )
  {
   u_char rbuf[32];
   rbuf[0] = 0;
   if(read_tty(rbuf, 1, 10) == 0)
    {
     if(kill_link == 1)
      {
       fprintf
        (
          stderr	,
         "\nRead device code terminaded.\n"
        );
//
       exit(1); 
      } 

     fprintf
      (
          stderr	,
       "\nRead byte timeout\n"
      );
//
     break;
    }

   code <<= 8;
   code |= rbuf[0];

#define CMD_DEV_ID    ((u_short)(('I' << 8) | ('D'))) // Read Device ID 
   if(code == CMD_DEV_ID)
    {
     break;
    }
  }

 if(code != CMD_DEV_ID)
  {
   fprintf
    (
     stderr	,
   "\nRead Device Id Timeout\n"
    );
 
   return(0);
  } 

// read device id value /////////////////////////////////////////////////////


 u_char mbuf[32];
 mbuf[0] = 0;				// 
 mbuf[1] = 0;				//
 if(read_tty(mbuf, 8, 10) == 0)
  {
   if(kill_link == 1)
    {
     fprintf
      (
          stderr	,
       "\nRead device ID terminaded.\n"
      );
//
     exit(1);
    } 

// 
   fprintf
    (
     stderr	,
   "\nRead Flash Device Id Timeout\n"
    );
//  
   return(0);
  }


//
 code = 0;
 int i;
 for(i = 0; i < 8; ++i)
  {
   code <<= 4;
   if(mbuf[i] >= '0' && mbuf[i] <= '9')
    {
     code |= (mbuf[i] - '0');
    }
   else
   if(mbuf[i] >= 'a' && mbuf[i] <= 'f')
    {
     code |= ((mbuf[i] - 'a') + 10);
    }
   else
   if(mbuf[i] >= 'A' && mbuf[i] <= 'F')
    {
     code |= ((mbuf[i] - 'A') + 10);
    }
   else
    {
     fprintf
      (
       stderr	,
     "\nError Device Id [%c%c%c%c%c%c%c%c]\n",
       mbuf[0]	,
       mbuf[1]	,
       mbuf[2]	,
       mbuf[3]	,
       mbuf[4]	,
       mbuf[5]	,
       mbuf[6]  ,
       mbuf[7]  
      );
  
     return(0);
    }
  }

 printf("\nDevice Id = [0x%08x]\n", code);
 return(1);
}

// 
FILE * prot_file_open(void)
{
 FILE * fprot = 0;			// protocol FILE
 if(protfilenam[0] == '\0') 		// protocol file mane
  {
   int size;
   size = sizeof(protfilenam);
   if(strstr(devnam, "ttyS0") != 0)
    {
     strncpy
      ( 
        protfilenam	, 
       "fprg.ttyS0"	, 
        size
      );
    }
   else
   if(strstr(devnam, "ttyS1") != 0)
    {    
     strncpy
      (
        protfilenam	, 
       "fprg.ttyS1"	, 
        size
      );
    }
   else
    {
     strncpy
      (
        protfilenam	, 
       "fprg.txt"	, 
        size
      );
    }
   protfilenam[size-1] = '\0';
  }

//   
 fprot = fopen(protfilenam, "w+t");
 if(fprot == 0)
  {
// protocol file open error /////////////////////////////////////////////////
   fprintf
    (
       stderr	,	 		// 
     "\nProtocol file [%s] open error\n",	// 
       protfilenam				// 
    );
//
   exit(1);				// exit from programm 
  }
//
 return(fprot);
}

/////////////////////////////////////////////////////////////////////////////
// terminal /////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

int proc_Terminal(void)
{
 FILE * fprot;				// protocol FILE
 fprot = prot_file_open();		// open log file 

 fd_set r_fds; 
 FD_ZERO(&r_fds);

// read stdin file descriptor //////////////////////////////////////////////

 int stdinfd;
 stdinfd = fileno(stdin);
 if(stdinfd < 0 || stdinfd >= (int)sizeof(r_fds) * 8)
  {
   fprintf
    (
      stderr, 
     "\nBad stdin descriptor\n"
    );
   return(0);
  }

 int maxfd;
 if(ttyfd[0] > stdinfd)
  {
   maxfd = ttyfd[0];
  }
 else
  {
   maxfd = stdinfd;
  }

 struct termios stdintios;	
 if(tcgetattr(stdinfd, &stdintios) < 0) 
  {
   fprintf(stderr,"\ntcgetattr stdin error: (%d)\n", errno);
   return(0);
  }

 struct termios tios;	
 tios = stdintios;
 
 cfmakeraw(&tios);

// 
 if(tcsetattr(stdinfd, TCSAFLUSH, &tios) < 0)
  {
   fprintf(stderr,"\ntcsetattr stdin error : (%d)\n", errno);
   return(0);
  }        

// 
 int lastbreak;
 int more;
 int rvl;
//
 lastbreak = 0;
 more = 1;
 rvl = 1; 


 while(more)
  {
   FD_SET	
    (
      ttyfd[0]	,			// tty descriptor 
     & r_fds				// read mask 
    );     

   FD_SET	
    (
      stdinfd	,			// stdin descriptor 
     & r_fds				// read descriptor 
    );     

// 
   struct timeval tval;	
   tval.tv_sec  = 1;
   tval.tv_usec = 0;

// 
   int cnt;
   cnt = select
    (
     maxfd + 1	, 
     & r_fds	, 
      0	 	, 
      0 	, 
     & tval	
    );

   if(kill_link == 1)
    {
     break;
    }

   if(cnt <= 0)
    {
     if(cnt < 0) 
      {
       fprintf
        ( 
         stderr	,
        "\nselect error : (%d)\n", 
         errno
        );

       rvl = 0;  
       break;
      }
     else
      {
       continue;
      }  
    }

   u_char rbuf[32];
   rbuf[0] = 0;

// 
   if(FD_ISSET(ttyfd[0],& r_fds))
    {
     cnt = read(ttyfd[0], rbuf, sizeof(rbuf));
     if(kill_link == 1)
      {
       break;
      } 

     if(cnt < 0) 
      {
       fprintf
        ( 
         stderr	,
        "\nTYY read error : (%d)\n", 
         errno
        );

       rvl = 0;
       break;  
      }

     int pos;
     for(pos = 0; pos < cnt; ++pos)
      {
       if(fprot != 0)
        {
// protocol file defined => write to protocol file read from tty character ///
        fprintf(fprot,"%c",rbuf[pos]);
        fflush(fprot);
	}

       if(terminal_hex_opt)
        {  
         fprintf(stdout,"%02x ",rbuf[pos]);
        }
       else
        { 
         fprintf(stdout,"%c",rbuf[pos]);
        }
      }
     fflush(stdout);
    }

// 
   if(FD_ISSET(stdinfd,& r_fds))
    {
     cnt = read(stdinfd, rbuf, sizeof(rbuf));
     if(kill_link == 1)
      {
       break;
      } 

     if(cnt < 0) 
      {
       fprintf
        ( 
         stderr	,
        "\nstdin read error : (%d)\n", 
         errno
        );

       rvl = 0;  
       break;
      }


     if(cnt > 0)
      {
       int pos;
       for(pos = 0; pos < cnt; ++pos)
        {
         if(rbuf[pos] == 0x03)
	  {
// break received 
           if(tcsendbreak(ttyfd[0], 2) != 0)
	    {
             printf("\ntcsendbreak error\n");
	    }
           
	   if(lastbreak == 1)
	    {    
    	     more = 0;
  	     break;
            }
	   else
	    {
             lastbreak = 1;
             continue;
	    }    
	  } 
         else
	  {
	   lastbreak = 0;
          }

         if(echo_opt == 1)
	  {
           if(fprot != 0)
            {
// protocol file defined => write to protocol file read from tty character ///
             fprintf( fprot,"%c",rbuf[pos]);
     	    }
// 
           fprintf(stdout,"%c",rbuf[pos]);
           fflush(stdout);
	  }

// 
         write(ttyfd[0], rbuf + pos, 1);
        } 
      }
    }
  }

 if(tcsetattr(stdinfd, TCSAFLUSH, &stdintios) < 0)
  {
   fprintf(stderr,"\ntcsetattr stdin error : (%d)\n", errno);
   rvl = 0;
  }        

 if(fprot != 0)
  {
   fclose(fprot);
  }

// 
 return(rvl);
}

/* */

int proc_Loopback(void)
{
/* */
 int rvl;				/* return code */
/* */
 rvl = 1; 				/* start return code */

 FILE * fprot;				/* protocol FILE */
 FILE * fstat;				/* statistics file */
 if(detach_cmd == 1) { 
    char * fnam;
    fnam = "/var/log/fprglooperror";	/* log file name */
    fprot = fopen(fnam,"r+t");		/* open log file */
    if(fprot == 0) {
	fprot = fopen(fnam,"w+t");	/* open log file */
    } else {
	if(fseek(fprot, SEEK_END, 0L) < 0) {
	    rvl = 0;
	}
    }

    fnam = "/var/log/fprgloopstat";		/* statistic file name */
    fstat = fopen(fnam,"r+t");			/* open stat file */
    if(fstat == 0) {
	fstat = fopen(fnam,"w+t");		/* open stat file */
    } else {
	if(fseek(fstat, SEEK_END, 0L) < 0) {
	    rvl = 0;
	}
    }
 } else {
    fprot = 0;				/* empty protocol file in nodetach mode */
    fstat = 0;				/* empty stat file in nodetach mode */
 }


/* */
 fd_set r_fds; 				/* read mask */
 fd_set w_fds; 				/* write mask */
 FD_ZERO(&r_fds);			/* clear read mask */
 FD_ZERO(&w_fds);			/* clear write mask */

/* read stdin file descriptor */

 int stdinfd;
 stdinfd = fileno(stdin);
 if((stdinfd < 0) || (stdinfd >= (int)sizeof(r_fds) * 8)) {
    fprintf(
	stderr, 
	"\nBad stdin descriptor\n"
    );
   return(0);
 }

/* */
 int maxfd;				/* maximal descriptor number */
 maxfd = -1;				/* init maximal descriptor number */
 if(ttyfd[0] > maxfd) {
    maxfd = ttyfd[0];
 }
 if(ttyfd[1] > maxfd) {
    maxfd = ttyfd[1];
 }

 if(detach_cmd == 0) {
    if(stdinfd > maxfd) {
	maxfd = stdinfd;
    }
 }

 struct termios stdintios;	
 if(detach_cmd == 0) {
    if(tcgetattr(stdinfd, &stdintios) < 0) {
	fprintf(stderr,"\ntcgetattr stdin error: (%d)\n", errno);
	return(0);
    }

    struct termios tios;	
    tios = stdintios;

    cfmakeraw(&tios);
/* */
    if(tcsetattr(stdinfd, TCSAFLUSH, &tios) < 0) {
	fprintf(stderr,"\ntcsetattr stdin error : (%d)\n", errno);
	return(0);
    }        

    fprintf(stderr,"ttyfd0 (%d), ttyfd1 (%d)\n", ttyfd[0], ttyfd[1]);
 }

/* */
 u_int32_t cht[2];			/* readed characters */
 u_int32_t che[2];			/* error characters */
 u_int8_t chw[2];			/* write character */
 u_int8_t chr[2];			/* read character */
 cht[1] = cht[0] = 0;			/* readed characters */
 chw[1] = chw[0] = 0;			/* write character */
 chr[1] = chr[0] = 0;			/* read character */
 che[1] = che[0] = 0;			/* error characters */
/* */
 int lastbreak;				/* previous character break */
 lastbreak = 0;				/* clear previous break flag */

/* /etc/rc.d/rc huck */
 char * lname = "/var/lock/subsys/fprg";
 if(access(lname,F_OK) < 0) {
/* file not exist -> create file */
    FILE * lfile;			/* lock file */
    lfile = fopen(			/* open lock file */
	lname, 				/* loack file name */
	"w+b"				/* file mode */
    );	
    if(lfile == 0) {
/* lock file creation error -> check dirrectory tree */
	struct stat stbuf;		/* file status buffer */
	/* read file status */
	if(stat("/var", &stbuf) >= 0) {		
	    if(S_ISDIR(stbuf.st_mode) != 0) {
		/* read file status */
		if(stat("/var/lock", &stbuf) >= 0) {
		    if(S_ISDIR(stbuf.st_mode) != 0) {
    		    /* read file status */
			if(stat("/var/lock/subsys", &stbuf) >= 0) {
			    if(S_ISDIR(stbuf.st_mode) != 0) {
/* normal directory structure -> print error message */
				rvl = 0;
				if(fprot != 0) {
				    fprintf(
					fprot,	
					"File {%s} create error\n", 
					lname
				    );
				}
			    }
			}
		    }
		}
	    }	
	}
    }

    if(lfile != 0) {
    /* close lock file */
	if(fclose(lfile) < 0) {
	    rvl = 0;
	}
    }
 }

 if(detach_cmd != 0) {
    int pid;
    pid = fork();
    if(pid != 0) {
	exit(1);
    }

    close(0);
    close(1);
    close(2);
    quiet_cmd = 1;
 }

 FILE * fmes;
 if(detach_cmd == 1) { 
    fmes = fprot;
 } else {
    fmes = stderr;
 }

/* */
 if((fstat == 0) && (detach_cmd == 0))  {
    fstat = stdout;
 }

 while(1) {
    int chp;				/* print message flag */
    chp = 0;

    if(ttyfd[0] >= 0) {
	FD_SET(				/* set   */
    	    ttyfd[0],			/* tty descriptor */
    	    & r_fds			/* read mask */
	);     
	FD_SET(
    	    ttyfd[0],			/* tty descriptor */
    	    & w_fds			/* read mask */
	);     
    }

    if(ttyfd[1] >= 0) {
	FD_SET(
    	    ttyfd[1],			/* tty descriptor */
    	    & r_fds			/* read mask */
	);     
	FD_SET(
    	    ttyfd[1],			/* tty descriptor */
    	    & w_fds			/* read mask */
	);     
    }

    if(detach_cmd == 0) {
	FD_SET(
    	    stdinfd,			/* stdin descriptor */
    	    & r_fds			/* read descriptor */
	);
    }

/* */
    struct timeval tval;		/* timeout  */
    tval.tv_sec  = 1;			/* seconds */
    tval.tv_usec = 0;			/* micro seconds */

/* */
    int cnt;
    cnt = select(
	maxfd + 1, 			/* descriptors count */
	& r_fds, 			/* read mask */
	& w_fds, 			/* write mask */
	0, 				/* exeption mask */
	& tval				/* timeout value */
    );

    if(kill_link == 1) {
	break;				/* 1 */
    }

    if(cnt == 0) {
        continue;
    }
    
    if(cnt < 0) {
/* process select error */
	if(fmes != 0) { 
    	    fprintf( 
		fmes,
		"\nselect error : (%d)\n", 
		errno
	    );
	}
	
	rvl = 0;  
	{ break; }				/* 2 */
    }

    u_char wbuf[32];
    u_char rbuf[32];
    rbuf[0] = 0;

/* */
    if(FD_ISSET(stdinfd,& r_fds)) {
	cnt = read(stdinfd, rbuf, sizeof(rbuf));
	if(kill_link == 1) {
	    break;				/* 3 */
	} 

	if(cnt < 0) {
	    if(fmes != 0) { 
		fprintf( 
		    fmes,
		    "\nstdin read error : (%d)\n", 
		    errno
		);
	    }

	    rvl = 0;  
	    break;				/* 4 */
	}

	if(cnt > 0) {
	    int pos;
	    for(pos = 0; pos < cnt; ++pos) {
		if(rbuf[pos] == 0x03) {
		    int ttyn;
		    for(ttyn = 0; ttyn < 2; ++ttyn) {
			if(ttyfd[ttyn] >= 0) {
			    if(tcsendbreak(ttyfd[ttyn], 2) != 0) {
				if(fmes != 0) { 
				    fprintf(
					fmes, 
					"\ntcsendbreak error\n"
				    );
				}
			    }
			}
		    }

		    if(fmes != 0) { 
			fprintf(fmes,"<break>\n");
        	    }
		    if(lastbreak == 1) {    
			lastbreak = 2;
			break;
		    } else {
			lastbreak = 1;
			continue;
		    }    
		} else {
		    lastbreak = 0;
		}

		int ttyn;
		for(ttyn = 0; ttyn < 2; ++ttyn) {
		    if(ttyfd[ttyn] >= 0) {
		        if(write(ttyfd[ttyn], rbuf + pos, 1) != 1) {
		    	    rvl = 0;
			}
    		    }
		}
	    } 

    	    if(lastbreak > 1) {
		lastbreak = 0;
		break;				/* 4 */
	    }
	}
    }

/* */
    rbuf[0] = 0;

/* */
    int ttyn;
    for(ttyn = 0; ttyn < 2; ++ttyn) {
        if(ttyfd[ttyn] < 0) {
	    continue;
	}

	if(FD_ISSET(ttyfd[ttyn],& r_fds)) {
	    cnt = read(ttyfd[ttyn], rbuf, sizeof(rbuf));
	    if(kill_link == 1) {
		break;				/* 5 */
	    } 

	    if(cnt < 0) {
		if(fmes != 0) { 
		    fprintf( 
			fmes,
		        "\nTYY read error : (%d)\n", 
			errno
		    );
		}
		
		rvl = 0;
		break;  			/* 6 */
	    }
	    if(cnt > 0) {
		int rpos;
		for(rpos = 0; rpos < cnt; ++rpos) {
		    if(rbuf[rpos] != chr[ttyn]) {
			if(fmes != 0) { 
			    fprintf(
				fmes, 
			        "\nWait %3d received %3d\n", 
				chr[ttyn], 
			        rbuf[rpos]
			    );
			}
			che[ttyn] += 1;		/* read errors */
			chr[ttyn] = rbuf[rpos];	/* reset read character */
		        chp = 1;		/* print error message */
		    }
		    chr[ttyn] += 1;		/* next read character */
		    cht[ttyn] += 1;
		    if((cht[ttyn] % 1000) == 0) {
			chp = 1;
		    }
		}
    	    }
	}

	if(FD_ISSET(ttyfd[ttyn],& w_fds)) {

	    int wpos;
	    for(wpos = 0; wpos < (int)sizeof(wbuf); ++wpos) {
		wbuf[wpos] = chw[ttyn] + wpos;	/* write character */
	    }
	    cnt = write(
		ttyfd[ttyn], 		/* interface descriptor */
		wbuf, 			/* write characters buffer */
		sizeof(wbuf)		/* bytes in buffer */
    	    );

	    if(kill_link == 1) {
		{ break; }			/* 7 */
	    } 

	    if(cnt < 0) {
		if(fmes != 0) { 
		    fprintf( 
			fmes,
			"\nTYY write error : (%d)\n", 
			errno
		    );
		}
		rvl = 0;
		break;  
	    }

	    chw[ttyn] += cnt;
	}
    }

    if((chp == 1 && fstat != 0)) {
	if(detach_cmd == 0) {
	    int spos;
	    for(spos = 0; spos < 70; ++spos) {
		fprintf(fstat,"\b");
	    }
	} else {
	    if(fseek(fstat, SEEK_SET, 0L) < 0) {
		rvl = 0;
	    } 
	}

	if((ttyfd[0] >= 0) && (ttyfd[1] >= 0)) {
	    fprintf( 
		fstat,
		"readed : (%d/%d) errors : (%d/%d)", 
		cht[0],
		cht[1],
		che[0],
		che[1]
	    );
	} else {
	    fprintf( 
		fstat,
		"writed : (%d) errors : (%d)", 
		cht[0],
		che[0]
	    );
	}
	fflush(fstat);
	chp = 0;
    }
 }

 if(detach_cmd == 0) {
    if(tcsetattr(stdinfd, TCSAFLUSH, &stdintios) < 0) {
	if(fmes != 0) {
	    fprintf(
		fmes,
		"\ntcsetattr stdin error : (%d)\n",
	        errno
	    );
	}
	rvl = 0;
    }        
 }

 if(fprot != 0) {
    fclose(fprot);
    fprot = 0;
 }

 if(fstat != 0) {
    fclose(fstat);
    fstat = 0;
 }

/* */
 return(rvl);
}

/* */

int proc_Echo_Test(void)
{ 
 FILE * fprot = prot_file_open();	// protocol FILE
 int maxfd = ttyfd[0];
 int more = 1;
 int rvl = 1;
 int rxcount = 0;
 fd_set r_fds; 
 FD_ZERO(&r_fds);
//
 while(more)
  {
   FD_SET(ttyfd[0], & r_fds);     
// 
   struct timeval tval;	
   tval.tv_sec  = 1;
   tval.tv_usec = 0;
// 
   int cnt;
   cnt = select( maxfd + 1, & r_fds,  0,  0, & tval);
   if(kill_link == 1) {  break; }

   if(cnt <= 0)
    {
     if(cnt < 0) 
      {
       fprintf( stderr, "\nselect error : (%d)\n", errno );
       rvl = 0;  
       break;
      }
     else
      {
       continue;
      }  
    }

   u_char rbuf[256];
   rbuf[0] = 0;
// 
   if(FD_ISSET(ttyfd[0],& r_fds))
    {
     cnt = read(ttyfd[0], rbuf, sizeof(rbuf));
     if(kill_link == 1) { break; } 
     if(cnt < 0) 
      {
       fprintf(stderr, "\nTYY read error : (%d)\n", errno);
       rvl = 0;
       break;  
      }

     int pos;
     for(pos = 0; pos < cnt; ++pos)
      {
       if(fprot != 0)
        {
// protocol file defined => write to protocol file read from tty character ///
        fprintf(fprot,"%c",rbuf[pos]);
	}
       rxcount++;
       if( (rxcount % 0x10000) == 0 && rxcount != 0) 
        {
         printf("Rx=%d bytes\n", rxcount);
	}
      }

     if(fprot != 0)
      {
       fflush(fprot);
      }
// out received bytes to tty 
     write(ttyfd[0], rbuf, cnt);
    }
  }

 if(fprot != 0)
  {
   fclose(fprot);
  }

// 
 return(rvl);
}


int main(int argc, char *argv[])
{
 options_from_file("./fprg.cfg");
 if(parse_args(argc-1, argv+1) == 0) 
  {
// parse command line args error /////////////////////////////////////////////
   exit(1);
  }

 if(
    (erase_cmd              == 0) && 	// erase command flag
    (erase_sectors_cmd      == 0) && 	// erase command flag
    (write_cmd              == 0) && 	// write command flag 
    (read_cmd               == 0) &&	// read command flag
    (read_registers         == 0) && 	// read registers command 
    (dram_test_cmd          == 0) &&	// dram test command

    (dram_test_cmd          == 0) &&	// dram test command
    (dram_byte_test_cmd     == 0) &&	// dram test command
    (dram_halfword_test_cmd == 0) &&	// dram test command
    (dram_word_test_cmd     == 0) &&	// dram test command

    (manufactory_cmd        == 0) &&	// read manufactory cmd 
    (deviceid_cmd           == 0) &&	// read device id
    (fastwrite_cmd          == 0) &&	// fast flash write command
    (terminal_cmd           == 0) &&
    (loopback_cmd           == 0) &&	/* loopback mode */
    (echo_test_cmd          == 0)
  ) {
   fprintf(stderr,"\nCommand undefined\n");
   usage();
   exit(1);
  }

// set signal functions //////////////////////////////////////////////////////
 sigset_t mask;			
 sigemptyset(&mask);		
 sigaddset(&mask, SIGHUP);	
 sigaddset(&mask, SIGINT);	
 sigaddset(&mask, SIGTERM);
 sigaddset(&mask, SIGCHLD);
 sigaddset(&mask, SIGUSR2);

#define SIGNAL(s, handler)	do { \
	sa.sa_handler = handler; \
	if (sigaction(s, &sa, NULL) < 0) \
	    { fprintf(stderr,"sigaction error (%d)\n", s); exit(1); } \
    } while (0)


 struct sigaction sa;			// sigaction 
 sa.sa_mask = mask;
 sa.sa_flags = 0;

 SIGNAL(SIGHUP	 , bad_signal);		/* SIGHUP */
 SIGNAL(SIGINT	 , term);		/* SIGINT */	
 SIGNAL(SIGQUIT  , bad_signal);		/* SIGQUIT */
 SIGNAL(SIGILL   , bad_signal);		/* SIGILL */
#ifdef SIGTRAP
 SIGNAL(SIGTRAP  , bad_signal);		/* SIGTRAP */
#endif
 SIGNAL(SIGABRT  , bad_signal);		/* SIGABRT */
#ifdef SIGBUS
 SIGNAL(SIGBUS   , bad_signal);		/* SIGBUS */
#endif

 SIGNAL(SIGFPE   , bad_signal);		/* SIGFPE */
 SIGNAL(SIGUSR1  , bad_signal);		/* SIGUSR1 */
 SIGNAL(SIGSEGV  , bad_signal);		/* SIGSEGV */
 SIGNAL(SIGUSR2  , bad_signal);		/* SIGUSR2 */
 SIGNAL(SIGALRM  , bad_signal);		/* SIGALRM */	 
 SIGNAL(SIGTERM	 , term);		/* SIGTERM Terminate */
 SIGNAL(SIGPIPE  , bad_signal);		/* SIGPIPE */
 SIGNAL(SIGCHLD  , chld_signal);	/* SIGCHLD */
 SIGNAL(SIGCONT  , bad_signal);		/* SIGCONT */

// SIGNAL(SIGSTOP  , bad_signal);	/* SIGCONT */

 SIGNAL(SIGTSTP  , bad_signal);		/* SIGTSTP */
 SIGNAL(SIGTTIN  , bad_signal);		/* SIGTSTP */
 SIGNAL(SIGTTOU  , bad_signal);		/* SIGTTOU */
 SIGNAL(SIGURG   , bad_signal);		/* SIGURG  */

#ifdef SIGXCPU
 SIGNAL(SIGXCPU, bad_signal);		/* SIGXCPU */
#endif
#ifdef SIGXFSZ
 SIGNAL(SIGXFSZ, bad_signal);		/* SIGXFSZ */
#endif
#ifdef SIGVTALRM
 SIGNAL(SIGVTALRM,bad_signal);		/* SIGVTALRM */
#endif
#ifdef SIGPROF
 SIGNAL(SIGPROF  , bad_signal);		/* SIGPROF */
#endif
#ifdef SIGWINCH
 SIGNAL(SIGWINCH , bad_signal);		/* SIGWINCH */
#endif
 SIGNAL(SIGIO    , bad_signal);		/* SIGIO */
 SIGNAL(SIGPWR   , bad_signal);		/* SIGPWR */
#ifdef SIGEMT
 SIGNAL(SIGEMT   , bad_signal);
#endif
#ifdef SIGPOLL
 SIGNAL(SIGPOLL  , bad_signal);
#endif
#ifdef SIGSYS
 SIGNAL(SIGSYS   , bad_signal);
#endif

//
 if(strcmp(devnam,"/dev/ttyS") == 0) {
/* open /dev/ttyS0 & open /dev/ttyS1 */
    ttyfd[0] = open(
	"/dev/ttyS0", 			/* open /dev/ttyS0 */
	O_NONBLOCK |			/* NONBLOCK mode */
	O_RDWR, 			/* read/write */
	0	
    );

    if(ttyfd[0] == -1) {		/* ttyS0 open error */
	fprintf(stderr,"Device open error [/dev/ttyS0]\n");
	exit(1);			/* exit */
    }

    ttyfd[1] = open(
	"/dev/ttyS1", 			/* open /dev/ttyS1 */
	O_NONBLOCK |			/* NONBLOCK mode */
	O_RDWR, 			/* read/write */
	0	
    );

    if(ttyfd[1] == -1) {		
    /* open ttyS1 error */
	close(ttyfd[0]);		/* close ttyS0 */
	ttyfd[0] = -1;			/* clear tty 0 descriptor */
	ttyfd[1] = -1;			/* clear tty 1 descriptor */
	fprintf(
	    stderr,
	    "Device open error [/dev/ttyS1]\n"
	);
	exit(1);			/* */
    }
 } else {
    ttyfd[0] = open(
	devnam, 			// device name 
	O_NONBLOCK |			// NONBLOCK mode 
	O_RDWR, 			// read/write	
	0	
    );

    if(ttyfd[0] == -1) {
	fprintf(
	    stderr,"Device open error [%s]", 
	    devnam
	);
	exit(1);
    }
 }

 int ttyn;
 for(ttyn = 0; ttyn < 2; ++ttyn) {
/* */    
    if(ttyfd[ttyn] == -1) {
	continue;
    }

    int fdflags;
    fdflags = fcntl(ttyfd[ttyn], F_GETFL);	
    if(
	(fdflags == -1) || 
	(fcntl(ttyfd[ttyn], F_SETFL, (fdflags | O_NONBLOCK)) < 0)
    ) {
	fprintf(
	    stderr,
    	    "set O_NONBLOCK mode error\n"
        );
    }

    struct stat statbuf;
    if(
	fstat(ttyfd[ttyn], &statbuf) < 0 || 
        fchmod(ttyfd[ttyn], statbuf.st_mode & ~(S_IWGRP | S_IWOTH)) < 0
    ) {
	fprintf(
	    stderr,
	    "fchmod %s error\n", 
	    devnam
	 );
    } else {
	tty_mode[ttyn] = statbuf.st_mode;
    }

/* setup tty device */
    setup_tty(ttyn, 0);
 }


 if(terminal_cmd == 1) {		// process terminal command
   if(proc_Terminal() == 0) { } 
   return(1);
 }

 if(loopback_cmd == 1) {		/* loopback mode */
   if(proc_Loopback() == 0) { } 
   return(1);
 }

 if(echo_test_cmd == 1)
  {
   if(proc_Echo_Test() == 0)
    {
    } 
// 
   return(1);
  }
 
//
 int rvl;
// 
 rvl = 1;


 if(manufactory_cmd && rvl == 1)
  {
// read manufactory cmd ////////////////////////////////////////////////////// 
   if(proc_Manufactory() == 0)
    {
     rvl = 0;
    } 
  }
  
 if(deviceid_cmd && rvl == 1)
  {
// read device id //////////////////////////////////////////////////////////// 
   if(proc_Deviceid() == 0)
    {
     rvl = 0;
    } 
  }

// 
 if(erase_cmd && rvl == 1)
  {
// erase flash /////////////////////////////////////////////////////////////// 
   if(proc_Erase() == 0)
    {
     rvl = 0;
    }
  }

 if(erase_sectors_cmd && rvl == 1)
  {
// erase flash sectors /////////////////////////////////////////////////////// 
   if(proc_EraseSectors() == 0)
    {
     rvl = 0;
    }
  }

 if(dram_test_cmd && rvl == 1)
  {
// DRAM test command /////////////////////////////////////////////////////////
   if(proc_DramTest(0) == 0)
    {
     rvl = 0;
    }
  }

 if(dram_byte_test_cmd && rvl == 1)
  {
// dram byte test ////////////////////////////////////////////////////////////
   if(proc_DramTest(1) == 0)
    {
     rvl = 0;
    }
  }

 if(dram_halfword_test_cmd && rvl == 1)
  {
// dram half word test ///////////////////////////////////////////////////////
   if(proc_DramTest(2) == 0)
    {
     rvl = 0;
    }
  }

 if(dram_word_test_cmd && rvl == 1)
  {
// dram half word test ///////////////////////////////////////////////////////
   if(proc_DramTest(4) == 0)
    {
     rvl = 0;
    }
  }

 if(fastwrite_cmd == 1 && rvl == 1)
  {
// fast flash write command ////////////////////////////////////////////////// 

   if(proc_FastWrite() == 0)
    {
     rvl = 0;
    }
  }
 else
 if(write_cmd && rvl == 1)
  {
// write flash /////////////////////////////////////////////////////////////// 
   if(proc_Write() == 0)
    {
     rvl = 0;
    }
  }

 if(read_cmd && rvl == 1)
  {
// read flash //////////////////////////////////////////////////////////////// 
   if(proc_Read() == 0)
    {
     rvl = 0;
    }
  }

 if(read_registers && rvl == 1)
  {
// read registers command //////////////////////////////////////////////////// 
   if(proc_ReadRegisters() == 0)
    {
     rvl = 0;
    }
  }


/* */
 if(ttyfd[0] >= 0) {			
    close_tty(0);			/* close tty 0 */
 }    
 if(ttyfd[1] >= 0) {
    close_tty(1);			/* close tty 1 */
 }
 return(1);
}



