#ifndef __FPRG_H__
#define __FPRG_H__

#include <sys/param.h>		/* for MAXPATHLEN and BSD4_4, if defined */
#include <net/ppp_defs.h>
#include <stdarg.h>

/*
 * (c) 2006-2009 Dmitriy I.Cherkashin, www.ucrouter.ru
 * email: dch@ucrouter.ru , divch@users.sourceforge.net , dch@ucrouter.com 
 * phone: +8-909-936-8809; ICQ: 474-363-900; AIM:divchaim; YAHOO:divchyah
 */

typedef unsigned char  U8;			
typedef unsigned short U16;		
typedef unsigned long  U32;

#define MAXWORDLEN	1024	//
#define MAXARGS		1	//


//////////////////////////////////////////////////////////////////////////////
// global varibles ///////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

extern char devnam[MAXPATHLEN];		// device name 
extern char inpfilenam[MAXPATHLEN]; 	// input file name	
extern char outfilenam[MAXPATHLEN]; 	// oupput file name 
extern char protfilenam[MAXPATHLEN]; 	// protocol file mane
extern int  inspeed;			// baudrate
extern int  verbose; 			// verbose mode 
extern int  erase_cmd;			// erase command flag  
extern int  erase_sectors_cmd;		// erase sector command
extern int  write_cmd;			// write command flag 
extern int  write_offset;		// 
extern int  write_speed;		// write spped 
extern int  read_cmd;			// read command flag
extern int  file_size; 			// read/write file size 
extern int  hash;			// 
extern int  block_size;			// read & write block size
extern int  read_registers;		// read registers command
extern int  dram_test_cmd;		// dram test command
extern int  dram_byte_test_cmd;		// dram test command (byte test)
extern int  dram_halfword_test_cmd;	// dram test command (half word test)
extern int  dram_word_test_cmd;		// dram test command (word test)
extern int  manufactory_cmd;		// read manufactory cmd 
extern int  deviceid_cmd;		// read device id
extern int  fastwrite_cmd;		// flash write command	
extern int  terminal_cmd;		// terminal command 
extern int  terminal_hex_opt;		// hex terminal flag			
extern int  loopback_cmd;		// loopback command 
extern int  detach_cmd;			/* detach command */
extern int  quiet_cmd;			/* quiet mode */
extern int  echo_opt;
extern int  echo_test_cmd;

// 
#define	FPRG_PATCHLEVEL		 0		// patch level
#define FPRG_VERSION		"1.4"		// version number 
#define FPRG_IMPLEMENTATION	""
#define FPRG_DATE	        "2002,2003"
#define FPRG_COPYRIGHT          "(c) 2002,2003 www.ucrouter.ru"

//////////////////////////////////////////////////////////////////////////////
// option definition /////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

typedef struct 
{
 char * name;				// option name (array of words)
 U32    type;				// option type 
#define OPT_FUNC  	0x00000001	// addr is pointer to void (*)(char **, int *)
#define OPT_U8		0x00000002	// addr is pointer to U8
#define OPT_U16		0x00000003	// addr is pointer to U16	
#define OPT_U32		0x00000004	// addr is pointer to U32 
#define OPT_INT		0x00000005	// addr is pointer to int 
#define OPT_STAT_STRING	0x00000006	// address is pointer to static string 
#define OPT_DUP_STRING  0x00000007	// address is char **
#define OPT_TYPE_MASK   0x0000FFFF	// type mask

// 
#define OPT_LOW_LIMIT   0x00010000	// low limit is valid  
#define OPT_UPPER_LIMIT 0x00020000	// upper limit is valid 
#define OPT_LIMITS      0x00030000	// limits mask
#define OPT_ZERO_OK     0x00040000	// zero value is valid 
#define OPT_HEX         0x00080000	// hex format 
#define OPT_NO_ARG      0x00100000	// option value = value

 void * addr;				// variable & function pointer 
 char * description;			// option description 
 int	value;				// default option value
 int   	lower_limit;			// low limit >= 
 int   	upper_limit;			// upper limit <= 
// if option type is OPT_STAT_STRING upper_limit = sizeof static buffer 
 char * source;				// option source 
} 
 OPTION;

extern void usage(void);
extern int options_from_file(char * filename);
extern int parse_args(int argc, char * *argv);

#endif								// __FPRG_H__
