#ifndef	lint
static const char rcsid[] = "$Id: seriallog.c,v 1.2 2001/10/25 23:56:29 efalk Exp $" ;
#endif

/* seriallog routines.  Write data to log file, tagged with timestamp
 * and channel.
 */

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <sys/time.h>
#include <time.h>

#include "zmodem.h"

static	struct timeval	timestamp = {0,0} ;
FILE	* zmodemlogfile = NULL ;

#define	DTIME	1500		/* timeout, milliseconds */

static	int	which = -1 ;	/* last transmitted */

static	char	obuf[4096] ;
static	int	olen = -1 ;

FILE * SerialLogFile = NULL ;

	/* flush out buffered text */

void SerialLogFlush()
{
 int i;

 if( SerialLogFile == NULL )
  {
   return ;
  }

 if(which != -1 && olen > 0 )
  {
   if(which == 0)
    {
     which = 'w';
    }
   else
   if(which == 1)
    {
     which = 'r';
    }


   fprintf
    (
     SerialLogFile		,
    "%c sec %d us %d len %d"	, 
     which			, 
     timestamp.tv_sec		, 
     timestamp.tv_usec		, 
     olen
    );

   i = fwrite(obuf, 1, olen, SerialLogFile) ;
   fprintf
    (
     SerialLogFile		,
    "\n"
    );
  }

 fflush(SerialLogFile);
 which = -1;
 olen = 0;
}


void SerialLog(const void *data, int len, int w)
{
 struct timezone	z ;
 struct timeval	time ;
 int	dt ;
 int	i ;

 if( SerialLogFile == NULL )
  return ;

 gettimeofday(&time, &z) ;
 dt = (time.tv_sec - timestamp.tv_sec)*1000 +
     (time.tv_usec - timestamp.tv_usec)/1000;

 if( w != which || dt > DTIME ) 
  {
   SerialLogFlush() ;
   which = w ;
   timestamp = time ;
  }

 while( len > 0 )
  {
   if( olen+len > sizeof(obuf) )
    {
     SerialLogFlush() ;
    }
    
   i = len > sizeof(obuf) ? sizeof(obuf) : len ;
   bcopy(data, obuf+olen, i) ;
   olen += i ;
   len -= i ;
  }
}


void zmodemlog(const char *fmt, ... )
{
	va_list ap;
	struct timeval tv ;
	struct tm *tm ;
static	int	do_ts = 1 ;

	if( zmodemlogfile == NULL )
	  return ;

	if( do_ts ) {
	  gettimeofday(&tv, NULL) ;
	  tm = localtime(&tv.tv_sec) ;
	  fprintf(zmodemlogfile, "%2.2d:%2.2d:%2.2d.%2.2ld: ",
	    tm->tm_hour, tm->tm_min, tm->tm_sec,
	    tv.tv_usec/10000) ;
	}
	do_ts = strchr(fmt, '\n') != NULL ;

	va_start(ap, fmt) ;
	vfprintf(zmodemlogfile, fmt, ap) ;
	va_end(ap) ;
}
